/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.terracotta.forge.plugin.FileList;
import org.terracotta.forge.plugin.SourceMapLocationMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="closure-compile", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=false)
public class GoogleClosureMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(property="filesets")
    private List<FileSet> filesets;
    @Parameter(property="filelists")
    private List<FileList> filelists;
    @Parameter(property="outputFile", required=true)
    private String outputFile;
    @Parameter(property="charset", defaultValue="${project.build.sourceEncoding}")
    private String charset;
    @Parameter(property="compilationLevel", defaultValue="SIMPLE_OPTIMIZATIONS")
    private String compilationLevel;
    @Parameter(property="sourceMapFile", defaultValue="")
    private String sourceMapFile;
    @Parameter(property="sourceMapFormat", defaultValue="V3")
    private String sourceMapFormat;
    @Parameter(property="sourceMapUrl")
    private String sourceMapUrl;
    @Parameter(property="externs")
    private ArrayList<String> externs;
    @Parameter(property="locationMapping")
    private List<SourceMapLocationMapping> locationMappings;
    @Parameter(property="prettyPrint", defaultValue="false")
    private boolean prettyPrint;

    public void execute() throws MojoExecutionException {
        boolean sourceMapEnabled;
        File outFile = new File(this.outputFile);
        outFile.getParentFile().mkdirs();
        List<SourceFile> inputs = this.getSourceFiles();
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.valueOf((String)this.compilationLevel).setDebugOptionsForCompilationLevel(options);
        options.setOutputCharset(this.charset);
        options.setPrettyPrint(this.prettyPrint);
        boolean bl = sourceMapEnabled = this.sourceMapFile.length() > 0;
        if (sourceMapEnabled) {
            options.setSourceMapOutputPath(this.sourceMapFile);
            options.setSourceMapFormat(SourceMap.Format.valueOf((String)this.sourceMapFormat));
            ArrayList<SourceMap.LocationMapping> locMap = new ArrayList<SourceMap.LocationMapping>();
            for (SourceMapLocationMapping sm : this.locationMappings) {
                locMap.add(new SourceMap.LocationMapping(sm.prefix.replace('/', File.separatorChar), sm.replacement == null ? "" : sm.replacement));
            }
            options.setSourceMapLocationMappings(locMap);
        }
        ArrayList<SourceFile> closesureExterns = new ArrayList<SourceFile>();
        for (String extern : this.externs) {
            closesureExterns.add(SourceFile.fromFile((String)extern, (Charset)Charset.forName(this.charset)));
        }
        Compiler compiler = new Compiler();
        compiler.compile(closesureExterns, inputs, options);
        if (compiler.hasErrors()) {
            throw new MojoExecutionException(compiler.getErrors()[0].description);
        }
        PrintWriter outputFileWriter = null;
        try {
            outputFileWriter = new PrintWriter(outFile, this.charset);
            outputFileWriter.append(compiler.toSource());
            if (sourceMapEnabled) {
                File sourceMapFilePath = new File(this.sourceMapFile);
                sourceMapFilePath.getParentFile().mkdirs();
                PrintWriter sourceMapWriter = new PrintWriter(sourceMapFilePath, this.charset);
                compiler.getSourceMap().appendTo((Appendable)sourceMapWriter, outFile.getName());
                sourceMapWriter.close();
                outputFileWriter.println();
                outputFileWriter.println("//# sourceMappingURL=" + this.sourceMapUrl);
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputFileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputFileWriter);
    }

    private List<SourceFile> getSourceFiles() {
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>();
        if (this.filelists != null) {
            for (FileList filelist : this.filelists) {
                for (String file : filelist.files) {
                    inputs.add(SourceFile.fromFile((File)new File(filelist.directory, file)));
                }
            }
        }
        if (this.filesets != null) {
            FileSetManager fsManager = new FileSetManager();
            for (FileSet fs : this.filesets) {
                for (String file : fsManager.getIncludedFiles(fs)) {
                    inputs.add(SourceFile.fromFile((File)new File(fs.getDirectory(), file)));
                }
            }
        }
        return inputs;
    }
}

