/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifactResolvingMojo
extends AbstractMojo {
    private static final Pattern MAVEN_COORDS_REGX = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<Repository> remoteRepositories;
    @Component
    protected ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    protected ArtifactFactory defaultArtifactFactory;

    private static String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    private void getAllNodes(DependencyNode node, Set<DependencyNode> currentNodes) {
        if (currentNodes.add(node)) {
            for (DependencyNode currentNode : node.getChildren()) {
                this.getAllNodes(currentNode, currentNodes);
            }
        }
    }

    protected Collection<Artifact> resolveArtifact(Artifact artifact) throws Exception {
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        resolvedArtifacts.add(this.completeArtifact(artifact));
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph(pomProject, (ArtifactFilter)new ScopeArtifactFilter("runtime"));
        HashSet<DependencyNode> nodes = new HashSet<DependencyNode>();
        this.getAllNodes(rootNode, nodes);
        nodes.remove(rootNode);
        for (DependencyNode node : nodes) {
            Artifact nodeArtifact = node.getArtifact();
            Artifact completeArtifact = this.completeArtifact(nodeArtifact);
            this.getLog().info((CharSequence)("completed artifact " + completeArtifact));
            resolvedArtifacts.add(completeArtifact);
        }
        return resolvedArtifacts;
    }

    protected Artifact completeArtifact(Artifact artifact) {
        Artifact completeArtifact = this.defaultArtifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier());
        artifact.setScope(artifact.getScope());
        completeArtifact.setFile(new File(this.localRepository.getBasedir(), this.localRepository.pathOf(completeArtifact)));
        return completeArtifact;
    }

    protected Artifact createArtifact(String coords) {
        Matcher m = MAVEN_COORDS_REGX.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = AbstractArtifactResolvingMojo.get(m.group(4), "jar");
        String classifier = AbstractArtifactResolvingMojo.get(m.group(6), "");
        String version = m.group(7);
        return this.defaultArtifactFactory.createArtifactWithClassifier(groupId, artifactId, version, extension, classifier);
    }

    protected Artifact getJavadocArtifact(Artifact artifact) {
        return this.completeArtifact(this.defaultArtifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", "javadoc"));
    }
}

