/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.terracotta.forge.plugin.util.JUnitReportCleaner;

public class FixJUnitReportMojo
extends AbstractMojo {
    protected MavenProject project;

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File sureFireReportDir = new File(this.project.getBuild().getDirectory(), "surefire-reports");
        if (!sureFireReportDir.isDirectory()) {
            this.getLog().debug((CharSequence)"surefire-reports folder was not found");
        } else {
            JUnitReportCleaner cleaner = new JUnitReportCleaner(this.getLog());
            File[] reports = sureFireReportDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("TEST-") && name.endsWith(".xml") || name.endsWith(".txt");
                }
            });
            if (reports.length == 0) {
                this.getLog().info((CharSequence)"No empty junit reports were found");
            }
            for (File report : reports) {
                File xmlReport;
                String className = cleaner.getClassname(report.getName());
                if (className == null) continue;
                if (report.getName().endsWith(".xml")) {
                    cleaner.cleanReport(report);
                    continue;
                }
                if (!report.getName().endsWith(".txt") || (xmlReport = new File(report.getParentFile(), "TEST-" + className + ".xml")).exists() && xmlReport.length() != 0L) continue;
                cleaner.createDefaultReport(xmlReport, className);
            }
        }
    }
}

