/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolveDependenciesMojo
extends AbstractMojo {
    private static final Pattern MAVEN_COORDS_REGX = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<Repository> remoteRepositories;
    @Component
    protected ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactFactory defaultArtifactFactory;
    @Parameter(required=true, readonly=true)
    protected List<String> artifacts;
    @Parameter(required=false)
    protected String excludeGroupIds;
    @Parameter(required=false)
    protected String excludeArtifactIds;
    @Parameter(required=false, defaultValue="true")
    protected boolean resolveTransitively;
    @Parameter(required=false, defaultValue="false")
    protected boolean doNotResolve;

    protected Collection<Artifact> resolve() throws Exception {
        ArrayList<Artifact> deps = new ArrayList<Artifact>();
        if (this.doNotResolve) {
            for (String artifact : this.artifacts) {
                deps.add(this.createArtifact(artifact));
            }
        } else {
            for (String artifact : this.artifacts) {
                deps.addAll(this.resolveArtifact(this.createArtifact(artifact)));
            }
        }
        if (!this.resolveTransitively) {
            this.retainOriginalArtifacts(deps);
        }
        this.excludeGroupIds(deps);
        this.excludeArtifactIds(deps);
        return deps;
    }

    private void getAllNodes(DependencyNode node, Set<DependencyNode> currentNodes) {
        currentNodes.add(node);
        for (DependencyNode currentNode : node.getChildren()) {
            this.getAllNodes(currentNode, currentNodes);
        }
    }

    protected Collection<Artifact> resolveArtifact(Artifact artifact) throws Exception {
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        resolvedArtifacts.add(this.completeArtifact(artifact));
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph(pomProject, (ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
        HashSet<DependencyNode> nodes = new HashSet<DependencyNode>();
        this.getAllNodes(rootNode, nodes);
        nodes.remove(rootNode);
        for (DependencyNode node : nodes) {
            Artifact nodeArtifact = node.getArtifact();
            Artifact completeArtifact = this.completeArtifact(nodeArtifact);
            resolvedArtifacts.add(completeArtifact);
        }
        return resolvedArtifacts;
    }

    private Artifact completeArtifact(Artifact artifact) {
        Artifact completeArtifact = this.defaultArtifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getScope(), artifact.getType());
        completeArtifact.setFile(new File(this.localRepository.getBasedir(), this.localRepository.pathOf(completeArtifact)));
        return completeArtifact;
    }

    private void excludeGroupIds(Collection<Artifact> deps) {
        if (this.excludeGroupIds == null) {
            return;
        }
        HashSet<String> exclusions = new HashSet<String>();
        for (String groupId : this.excludeGroupIds.split(",")) {
            exclusions.add(groupId.trim());
        }
        Iterator<Artifact> it = deps.iterator();
        while (it.hasNext()) {
            if (!exclusions.contains(it.next().getGroupId())) continue;
            it.remove();
        }
    }

    private void excludeArtifactIds(Collection<Artifact> deps) {
        if (this.excludeArtifactIds == null) {
            return;
        }
        HashSet<String> exclusions = new HashSet<String>();
        for (String groupId : this.excludeArtifactIds.split(",")) {
            exclusions.add(groupId.trim());
        }
        Iterator<Artifact> it = deps.iterator();
        while (it.hasNext()) {
            if (!exclusions.contains(it.next().getArtifactId())) continue;
            it.remove();
        }
    }

    private Collection<Artifact> getConfiguredArtifacts() {
        ArrayList<Artifact> ret = new ArrayList<Artifact>();
        for (String coords : this.artifacts) {
            ret.add(this.createArtifact(coords));
        }
        return ret;
    }

    private boolean isConfiguredArtifact(Artifact a, Collection<Artifact> configuredArtifacts) {
        for (Artifact itArtifact : configuredArtifacts) {
            if (!a.getGroupId().equals(itArtifact.getGroupId()) || !a.getArtifactId().equals(itArtifact.getArtifactId()) || !a.getBaseVersion().equals(itArtifact.getBaseVersion()) || !a.getType().equals(itArtifact.getType())) continue;
            return true;
        }
        return false;
    }

    private void retainOriginalArtifacts(Collection<Artifact> resolvedArtifacts) {
        Collection<Artifact> configuredArtifacts = this.getConfiguredArtifacts();
        Iterator<Artifact> it = resolvedArtifacts.iterator();
        while (it.hasNext()) {
            if (this.isConfiguredArtifact(it.next(), configuredArtifacts)) continue;
            it.remove();
        }
    }

    private Artifact createArtifact(String coords) {
        Matcher m = MAVEN_COORDS_REGX.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = AbstractResolveDependenciesMojo.get(m.group(4), "jar");
        String classifier = AbstractResolveDependenciesMojo.get(m.group(6), "");
        String version = m.group(7);
        return this.defaultArtifactFactory.createArtifactWithClassifier(groupId, artifactId, version, extension, classifier);
    }

    private static String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }
}

