/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JUnitReportCleaner
extends DefaultHandler {
    private final Set<String> UNWANTED_ELEMENTS = new HashSet<String>();
    private final Pattern CLASSNAME_FROM_XML = Pattern.compile("TEST-(.*)\\.xml");
    private final Pattern CLASSNAME_FROM_TXT = Pattern.compile("(.*)\\.txt");
    private static final String DEAULT_REPORT = "<?xml version='1.0' encoding='UTF-8'?>\n<testsuite errors='0' failures='1' name='CLASSNAME' tests='1' time='0.000'>\n  <testcase classname='CLASSNAME' name='test' time='0.0'>\n    <failure type='junit.framework.AssertionFailedError' message='Failed'>\n      Test has timeout or crashed. Please check logs for details.\n    </failure>\n  </testcase>\n  <system-out />\n  <system-err />\n</testsuite>\n";
    private StringBuilder reportBuffer;
    private StringBuilder currentText;
    private int deleteDepth;
    private int failCount;
    private final Log log;

    public JUnitReportCleaner(Log log) {
        this.log = log;
        this.UNWANTED_ELEMENTS.add("properties");
        this.UNWANTED_ELEMENTS.add("system-out");
        this.UNWANTED_ELEMENTS.add("system-err");
    }

    public void cleanReport(File report) {
        SAXParser parser;
        if (!report.exists()) {
            throw new RuntimeException("JUnit report " + report + " doesn't exist");
        }
        String className = this.getClassname(report.getName());
        if (report.length() == 0L) {
            this.createDefaultReport(report, className);
            return;
        }
        this.reset(report);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            PrintWriter writer;
            block12: {
                parser.parse(report, (DefaultHandler)this);
                writer = null;
                try {
                    writer = new PrintWriter(report);
                    IOUtils.write((String)this.reportBuffer.toString(), (Writer)writer);
                    if (this.failCount <= 0) break block12;
                    this.log.info((CharSequence)("TEST " + className + " FAILED."));
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            this.createDefaultReport(report, className);
        }
    }

    public void createDefaultReport(File report, String className) {
        String defaultReport = DEAULT_REPORT.replace("CLASSNAME", className);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(report);
            IOUtils.write((String)defaultReport, (Writer)writer);
            this.log.info((CharSequence)("TEST " + className + " FAILED."));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public String getClassname(String filename) {
        Matcher matcher = null;
        if (filename.endsWith(".xml")) {
            matcher = this.CLASSNAME_FROM_XML.matcher(filename);
        } else if (filename.endsWith(".txt")) {
            matcher = this.CLASSNAME_FROM_TXT.matcher(filename);
        }
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private void reset(File report) {
        this.reportBuffer = new StringBuilder();
        this.deleteDepth = 0;
        this.failCount = 0;
    }

    public void startDocument() throws SAXException {
        this.reportBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.deleteDepth == 0) {
            String s = new String(ch, start, length);
            if (s.trim().length() == 0) {
                return;
            }
            this.currentText.append(JUnitReportCleaner.escapeXML(s));
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.currentText = new StringBuilder();
        if ("testsuite".equals(name)) {
            String errors = attributes.getValue("errors");
            String failures = attributes.getValue("failures");
            if (errors != null) {
                this.failCount += Integer.valueOf(errors).intValue();
            }
            if (failures != null) {
                this.failCount += Integer.valueOf(failures).intValue();
            }
        }
        if (this.UNWANTED_ELEMENTS.contains(name)) {
            ++this.deleteDepth;
        }
        if (this.deleteDepth == 0) {
            this.reportBuffer.append("<" + name + " ");
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.reportBuffer.append(attributes.getQName(i) + "=\"" + JUnitReportCleaner.escapeXML(attributes.getValue(i)) + "\" ");
            }
            this.reportBuffer.append(">\n");
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.deleteDepth == 0) {
            if (this.currentText != null && this.currentText.length() > 0) {
                this.reportBuffer.append(this.currentText.toString()).append("\n");
            }
            this.reportBuffer.append("</" + name + ">\n");
            this.currentText = null;
        }
        if (this.UNWANTED_ELEMENTS.contains(name)) {
            --this.deleteDepth;
        }
    }

    private static String escapeXML(String s) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(s);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

