/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.Summary;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefirePlugin;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.terracotta.forge.plugin.FixJUnitReportMojo;
import org.terracotta.forge.plugin.ToolkitAPIVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaSurefirePlugin
extends SurefirePlugin {
    static final Map<ToolkitAPIVersion, String> BASE_CORE_VERSIONS = new ConcurrentHashMap<ToolkitAPIVersion, String>();
    private static final String TOOLKIT_TIM_GROUP_ID = "org.terracotta.toolkit";
    private static final String TOOLKIT_RUNTIME_GROUP_ID = "org.terracotta";
    private static final Pattern TOOLKIT_TIM_ARTIFACT_ID_PATTERN;
    private static final Pattern TOOLKIT_RUNTIME_ARTIFACT_ID_PATTERN;
    private final Map<ToolkitAPIVersion, String> baseCoreVersions;
    private String terracottaCoreVersion;
    private MavenProject project;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private List remoteRepositories;
    private ArtifactRepository localRepository;
    private ArtifactCollector artifactCollector;
    private ArtifactMetadataSource metadataSource;
    private boolean skipQualifierMatch;
    private boolean skipToolkitResolve;
    private boolean cleanJunitReports;
    private File listFile;
    private int poundTimes;
    private boolean devLog;

    public TerracottaSurefirePlugin() {
        this(BASE_CORE_VERSIONS);
    }

    public TerracottaSurefirePlugin(Map<ToolkitAPIVersion, String> baseCoreVersions) {
        this.baseCoreVersions = baseCoreVersions;
    }

    void setup(String terracottaCoreVersion, MavenProject project, ArtifactFactory factory, ArtifactResolver artifactResolver, List remoteRepositories, ArtifactRepository localRepository, ArtifactCollector artifactCollector, ArtifactMetadataSource metadataSource, boolean skipQualifierMatch, boolean skipToolkitResolve, boolean cleanJunitReports, File listFile, int poundTimes, boolean devLog) {
        this.terracottaCoreVersion = terracottaCoreVersion;
        this.project = project;
        this.artifactFactory = factory;
        this.artifactResolver = artifactResolver;
        this.remoteRepositories = remoteRepositories;
        this.localRepository = localRepository;
        this.artifactCollector = artifactCollector;
        this.metadataSource = metadataSource;
        this.skipQualifierMatch = skipQualifierMatch;
        this.skipToolkitResolve = skipToolkitResolve;
        this.cleanJunitReports = cleanJunitReports;
        this.listFile = listFile;
        this.poundTimes = poundTimes;
        this.devLog = devLog;
    }

    public boolean isCleanJunitReports() {
        return this.cleanJunitReports;
    }

    public void setCleanJunitReports(boolean cleanJunitReports) {
        this.cleanJunitReports = cleanJunitReports;
    }

    public void setListFile(File listFile) {
        this.listFile = listFile;
    }

    public File getListFile() {
        return this.listFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block33: {
            if (this.devLog) {
                File devLog4jFile;
                File currentDir = super.getWorkingDirectory();
                if (currentDir == null) {
                    currentDir = new File(".");
                }
                if (!(devLog4jFile = new File(currentDir, ".tc.dev.log4j.properties")).exists()) {
                    try {
                        devLog4jFile.getParentFile().mkdirs();
                        if (!devLog4jFile.createNewFile()) {
                            throw new IOException("createNewFile return false");
                        }
                    }
                    catch (IOException e1) {
                        this.getLog().error((Throwable)e1);
                        throw new MojoExecutionException("Failed to create " + devLog4jFile);
                    }
                }
            }
            this.getLog().debug((CharSequence)("terracottaCoreVersion: " + this.terracottaCoreVersion));
            if (!this.skipToolkitResolve && this.terracottaCoreVersion != null && this.terracottaCoreVersion.length() != 0) {
                try {
                    this.updateToolkitDependencies();
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException("error updating toolkit references", e);
                }
            }
            try {
                String shouldSkipTestsValue = this.project.getProperties().getProperty("should_skip_tests");
                if (shouldSkipTestsValue != null) {
                    this.getLog().warn((CharSequence)("'should_skip_tests' property found, value is " + shouldSkipTestsValue + ". This value overrides the 'skipTests' original setting."));
                    boolean shouldSkipTests = Boolean.valueOf(shouldSkipTestsValue);
                    this.setSkipTests(shouldSkipTests);
                }
                if (this.listFile != null) {
                    if (!this.listFile.exists()) {
                        this.getLog().warn((CharSequence)("listFile '" + this.listFile + "' specified but does not exist. No tests will be run"));
                        return;
                    }
                    this.getLog().info((CharSequence)("Running tests found in file " + this.listFile));
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(this.listFile);
                        List line = IOUtils.readLines((InputStream)input);
                        ArrayList<String> includeList = new ArrayList<String>();
                        for (String test : line) {
                            if ((test = test.trim()).length() == 0 || test.startsWith("#")) continue;
                            if (!test.endsWith(".java")) {
                                test = test + ".java";
                            }
                            includeList.add("**/" + test);
                        }
                        this.getLog().info((CharSequence)("Tests to run: " + includeList));
                        this.setIncludes(includeList);
                    }
                    catch (IOException e) {
                        try {
                            throw new MojoExecutionException(e.getMessage());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(input);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)input);
                }
                if (this.poundTimes > 1) {
                    if (this.getTest() == null) {
                        this.getLog().error((CharSequence)"poundTimes was set but -Dtest isn't");
                        throw new MojoFailureException("poundTimes was set but -Dtest isn't");
                    }
                    for (int i = 1; i <= this.poundTimes; ++i) {
                        this.getLog().info((CharSequence)("* POUNDING ITERATION: " + i));
                        try {
                            super.execute();
                            continue;
                        }
                        catch (MojoExecutionException e) {
                            this.getLog().error((CharSequence)("Test failed after iteration #" + i));
                            throw e;
                        }
                    }
                    this.getLog().info((CharSequence)("*** Pounded " + this.poundTimes + " times! Test passed."));
                } else {
                    super.execute();
                }
            }
            catch (MojoExecutionException e) {
                if (e.getCause() instanceof SurefireBooterForkException) {
                    SurefireHelper.reportExecution((SurefireReportParameters)this, (int)1, (Log)this.getLog());
                    break block33;
                }
                throw e;
            }
            finally {
                if (this.cleanJunitReports) {
                    this.getLog().info((CharSequence)"Fix Junit reports if needed");
                    FixJUnitReportMojo fixUnitReportMojo = new FixJUnitReportMojo();
                    fixUnitReportMojo.setPluginContext(this.getPluginContext());
                    fixUnitReportMojo.setProject(this.project);
                    fixUnitReportMojo.execute();
                }
            }
        }
    }

    protected boolean hasExecutedBefore() {
        if (this.poundTimes > 1) {
            return false;
        }
        return super.hasExecutedBefore();
    }

    private void updateToolkitDependencies() throws Exception {
        ProcessResult artifactsResults = this.process(TerracottaSurefirePlugin.wrap(this.project.getArtifacts()));
        ProcessResult dependenciesResult = this.process(TerracottaSurefirePlugin.wrap(this.project.getDependencies()));
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Wrapper w : dependenciesResult.processedItems) {
            Dependency dep = (Dependency)w.unwrap();
            for (ToolkitAPIVersion ver : this.baseCoreVersions.keySet()) {
                Exclusion exclusion = new Exclusion();
                exclusion.setArtifactId("terracotta-toolkit-" + ver.toString());
                exclusion.setGroupId(TOOLKIT_TIM_GROUP_ID);
                dep.addExclusion(exclusion);
                exclusion = new Exclusion();
                exclusion.setArtifactId("terracotta-toolkit-" + ver.toString() + "-ee");
                exclusion.setGroupId(TOOLKIT_TIM_GROUP_ID);
                dep.addExclusion(exclusion);
                exclusion = new Exclusion();
                exclusion.setArtifactId("terracotta-toolkit-" + ver.toString() + "-runtime");
                exclusion.setGroupId(TOOLKIT_RUNTIME_GROUP_ID);
                dep.addExclusion(exclusion);
                exclusion = new Exclusion();
                exclusion.setArtifactId("terracotta-toolkit-" + ver.toString() + "-runtime-ee");
                exclusion.setGroupId(TOOLKIT_RUNTIME_GROUP_ID);
                dep.addExclusion(exclusion);
            }
            dependencies.add(dep);
        }
        if (artifactsResults.tim != null && dependenciesResult.tim == null) {
            dependencies.add(artifactsResults.tim.asDependency());
        }
        if (artifactsResults.runtime != null && dependenciesResult.runtime == null) {
            dependencies.add(artifactsResults.runtime.asDependency());
        }
        this.project.setDependencies(dependencies);
        if (this.artifactResolver != null) {
            HashSet artifacts = this.project.createArtifacts(this.artifactFactory, null, null);
            artifacts = new HashSet(this.artifactResolver.resolveTransitively((Set)artifacts, this.project.getArtifact(), this.remoteRepositories, this.localRepository, this.metadataSource).getArtifacts());
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact a = (Artifact)iter.next();
                if (!a.getGroupId().equals(TOOLKIT_RUNTIME_GROUP_ID) && !a.getGroupId().equals(TOOLKIT_TIM_GROUP_ID) || !a.getArtifactId().startsWith("terracotta-toolkit-") || a.getDependencyTrail().size() <= 2) continue;
                iter.remove();
            }
            this.project.setArtifacts(artifacts);
        }
    }

    private static Collection<Wrapper> wrap(Collection toWrap) {
        if (toWrap == null) {
            return null;
        }
        ArrayList<Wrapper> rv = toWrap instanceof List ? new ArrayList() : new HashSet();
        for (Object o : toWrap) {
            if (o instanceof Artifact) {
                rv.add(new Wrapper((Artifact)o));
                continue;
            }
            if (o instanceof Dependency) {
                rv.add(new Wrapper((Dependency)o));
                continue;
            }
            throw new AssertionError((Object)o.getClass().getName());
        }
        return rv;
    }

    private ProcessResult process(Collection<Wrapper> collection) throws MojoExecutionException {
        Wrapper TIM = null;
        Wrapper Runtime2 = null;
        EnumMap<ArtifactType, ToolkitAPIVersion> maxVersions = new EnumMap<ArtifactType, ToolkitAPIVersion>(ArtifactType.class);
        ArrayList<Wrapper> remove = new ArrayList<Wrapper>();
        for (Wrapper wrapper : collection) {
            ToolkitAPIVersion ver = this.getToolkitAPIVersion(wrapper);
            if (ver == null) continue;
            this.adjustMaxVersion(wrapper, ver, maxVersions);
            if (TerracottaSurefirePlugin.isToolkitTIM(wrapper)) {
                if (TIM != null) {
                    if (ver.getMinor() > this.getToolkitAPIVersion(TIM).getMinor()) {
                        remove.add(TIM);
                        TIM = wrapper;
                        continue;
                    }
                    remove.add(wrapper);
                    continue;
                }
                TIM = wrapper;
                continue;
            }
            if (TerracottaSurefirePlugin.isToolkitRuntime(wrapper)) {
                if (Runtime2 != null) {
                    if (ver.getMinor() > this.getToolkitAPIVersion(Runtime2).getMinor()) {
                        remove.add(Runtime2);
                        Runtime2 = wrapper;
                        continue;
                    }
                    remove.add(wrapper);
                    continue;
                }
                Runtime2 = wrapper;
                continue;
            }
            throw new AssertionError((Object)wrapper.toString());
        }
        for (Wrapper wrapper : remove) {
            this.getLog().info((CharSequence)("Removing " + wrapper + " from dependency set"));
            collection.remove(wrapper);
        }
        block6: for (Map.Entry entry : maxVersions.entrySet()) {
            this.getLog().info((CharSequence)("Targeting Toolkit API version " + entry.getValue() + ", but higher minor version may be used based on availability"));
            switch ((ArtifactType)((Object)entry.getKey())) {
                case RUNTIME: {
                    this.setVersionForDependency(Runtime2, (ToolkitAPIVersion)entry.getValue());
                    continue block6;
                }
                case TIM: {
                    this.setVersionForDependency(TIM, (ToolkitAPIVersion)entry.getValue());
                    continue block6;
                }
            }
            throw new AssertionError(entry.getKey());
        }
        return new ProcessResult(collection, TIM, Runtime2);
    }

    private final ArtifactType getArtifactType(Wrapper artifact) {
        if (TerracottaSurefirePlugin.isToolkitTIM(artifact)) {
            return ArtifactType.TIM;
        }
        if (TerracottaSurefirePlugin.isToolkitRuntime(artifact)) {
            return ArtifactType.RUNTIME;
        }
        throw new AssertionError((Object)artifact.toString());
    }

    private void adjustMaxVersion(Wrapper artifact, ToolkitAPIVersion ver, EnumMap<ArtifactType, ToolkitAPIVersion> maxVersions) throws MojoExecutionException {
        ArtifactType key = this.getArtifactType(artifact);
        ToolkitAPIVersion existingMax = maxVersions.get((Object)key);
        if (existingMax == null) {
            maxVersions.put(key, ver);
        } else {
            if (ver.getMajor() != existingMax.getMajor()) {
                throw new MojoExecutionException("Crossing major toolkit API versions: " + ver.getMajor() + " and " + existingMax.getMajor() + " for " + artifact);
            }
            if (ver.getMinor() > existingMax.getMinor()) {
                this.getLog().info((CharSequence)("Higher toolkit minor version detected (" + ver + ") vs (" + existingMax + ")"));
                maxVersions.put(key, ver);
            }
        }
    }

    private void setVersionForDependency(Wrapper artifact, ToolkitAPIVersion startingApiVer) throws MojoExecutionException {
        String base = this.baseCoreVersions.get(startingApiVer);
        if (base == null) {
            throw new AssertionError((Object)("This plugin has no base core TC version defined for toolkit API version " + startingApiVer));
        }
        ToolkitAPIVersion apiVer = startingApiVer;
        String artifactId = artifact.getArtifactId();
        String toolkitRange = this.toolkitVersionRange(base);
        artifact.setVersion(toolkitRange);
        String coreQualifier = new DefaultArtifactVersion(this.terracottaCoreVersion).getQualifier();
        if (this.artifactResolver != null) {
            try {
                ArtifactVersion selectedVersion;
                Artifact a;
                while (true) {
                    VersionRange toolkitMavenRange = VersionRange.createFromVersionSpec((String)toolkitRange);
                    a = this.artifactFactory.createDependencyArtifact(artifact.getGroupId(), artifactId, toolkitMavenRange, artifact.getType(), artifact.getClassifier(), artifact.getScope(), false);
                    List allAvailableVersions = this.metadataSource.retrieveAvailableVersions(a, this.localRepository, this.remoteRepositories);
                    selectedVersion = null;
                    for (ArtifactVersion version : allAvailableVersions) {
                        if (!toolkitMavenRange.containsVersion(version) || !this.skipQualifierMatch() && !this.isQualifierMatch(coreQualifier, version)) continue;
                        if (selectedVersion == null) {
                            selectedVersion = version;
                            continue;
                        }
                        if (selectedVersion.compareTo((Object)version) >= 0) continue;
                        selectedVersion = version;
                    }
                    if (selectedVersion != null) break;
                    this.getLog().warn((CharSequence)("Cannot resolve " + artifactId + " with range " + toolkitRange + ". Moving to next minor API version"));
                    String prev = apiVer.getMajor() + "." + apiVer.getMinor();
                    apiVer = apiVer.nextMinorVersion();
                    String next = apiVer.getMajor() + "." + apiVer.getMinor();
                    base = this.baseCoreVersions.get(apiVer);
                    if (base == null) {
                        throw new MojoExecutionException("No suitable toolkit can be resolved");
                    }
                    artifactId = artifactId.replace(prev, next);
                }
                this.getLog().info((CharSequence)("Changing toolkit reference (" + artifact.getArtifactId() + ")"));
                artifact.setArtifactId(a.getArtifactId());
                artifact.setVersion(selectedVersion.toString());
                a.setVersion(selectedVersion.toString());
                HashSet<Artifact> collect = new HashSet<Artifact>();
                collect.add(a);
                this.artifactCollector.collect(collect, this.project.getArtifact(), this.localRepository, this.remoteRepositories, this.metadataSource, null, Collections.EMPTY_LIST);
                this.artifactResolver.resolve(a, this.remoteRepositories, this.localRepository);
                this.getLog().info((CharSequence)("   New reference: " + artifact.getArtifactId() + " " + artifact.getVersion()));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error resolving toolkit", e);
            }
        }
    }

    private boolean isQualifierMatch(String coreQualifier, ArtifactVersion version) {
        return coreQualifier == null && version.getQualifier() == null || coreQualifier != null && coreQualifier.equals(version.getQualifier());
    }

    private boolean skipQualifierMatch() {
        return this.skipQualifierMatch;
    }

    private String toolkitVersionRange(String base) {
        DefaultArtifactVersion baseCoreVersion = new DefaultArtifactVersion(base);
        DefaultArtifactVersion coreVersion = new DefaultArtifactVersion(this.terracottaCoreVersion);
        if (baseCoreVersion.getMajorVersion() != coreVersion.getMajorVersion()) {
            return null;
        }
        int major = 1 + (coreVersion.getMinorVersion() - baseCoreVersion.getMinorVersion());
        int minor = coreVersion.getIncrementalVersion() - baseCoreVersion.getIncrementalVersion();
        String qualifier = "";
        if (coreVersion.getQualifier() != null) {
            qualifier = "-" + coreVersion.getQualifier();
        }
        return "[" + major + "." + minor + ".0" + qualifier + "," + major + "." + (minor + 1) + ".0-SNAPSHOT)";
    }

    private static boolean isToolkitTIM(Wrapper artifact) {
        return TOOLKIT_TIM_GROUP_ID.equals(artifact.getGroupId()) && TOOLKIT_TIM_ARTIFACT_ID_PATTERN.matcher(artifact.getArtifactId()).matches();
    }

    private static boolean isToolkitRuntime(Wrapper artifact) {
        return TOOLKIT_RUNTIME_GROUP_ID.equals(artifact.getGroupId()) && TOOLKIT_RUNTIME_ARTIFACT_ID_PATTERN.matcher(artifact.getArtifactId()).matches();
    }

    private ToolkitAPIVersion getToolkitAPIVersion(Wrapper artifact) {
        Matcher m;
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        if (TOOLKIT_TIM_GROUP_ID.equals(groupId)) {
            Matcher m2 = TOOLKIT_TIM_ARTIFACT_ID_PATTERN.matcher(artifactId);
            if (m2.matches()) {
                return new ToolkitAPIVersion(m2.group(1), m2.group(2));
            }
        } else if (TOOLKIT_RUNTIME_GROUP_ID.equals(groupId) && (m = TOOLKIT_RUNTIME_ARTIFACT_ID_PATTERN.matcher(artifactId)).matches()) {
            return new ToolkitAPIVersion(m.group(1), m.group(2));
        }
        return null;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setTerracottaCoreVersion(String terracottaCoreVersion) {
        this.terracottaCoreVersion = terracottaCoreVersion;
    }

    protected void handleSummary(Summary summary) throws MojoExecutionException, MojoFailureException {
        try {
            super.handleSummary(summary);
        }
        catch (MojoExecutionException e) {
            if (this.isTestFailureIgnore()) {
                this.getLog().error((Throwable)e);
            }
            throw e;
        }
        catch (MojoFailureException e) {
            if (this.isTestFailureIgnore()) {
                this.getLog().error((Throwable)e);
            }
            throw e;
        }
    }

    static {
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 0), "3.3.0");
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 1), "3.3.0");
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 2), "3.3.0");
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 3), "3.3.0");
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 4), "3.3.0");
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 5), "3.3.0");
        BASE_CORE_VERSIONS.put(new ToolkitAPIVersion(1, 6), "3.3.0");
        TOOLKIT_TIM_ARTIFACT_ID_PATTERN = Pattern.compile("^terracotta-toolkit-(\\d+)\\.(\\d+)(\\-ee)?$");
        TOOLKIT_RUNTIME_ARTIFACT_ID_PATTERN = Pattern.compile("^terracotta-toolkit-(\\d+)\\.(\\d+)-runtime(\\-ee)?$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ArtifactType {
        TIM,
        RUNTIME;

    }

    private static class Wrapper {
        private final String groupId;
        private String artifactId;
        private String version;
        private final String classifier;
        private final String type;
        private final String scope;
        private final Object obj;

        public Wrapper(Artifact a) {
            this(a, a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getType(), a.getScope());
        }

        public Dependency asDependency() {
            Dependency d = new Dependency();
            d.setArtifactId(this.artifactId);
            d.setClassifier(this.classifier);
            d.setGroupId(this.groupId);
            d.setScope(this.scope);
            d.setType(this.type);
            d.setVersion(this.version);
            return d;
        }

        public Wrapper(Dependency d) {
            this(d, d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType(), d.getScope());
        }

        private Wrapper(Object obj, String groupId, String artifactId, String version, String classifier, String type, String scope) {
            this.obj = obj;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
            this.type = type;
            this.scope = scope;
        }

        public String getScope() {
            return this.scope;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setVersion(String version) {
            if (this.obj instanceof Artifact) {
                ((Artifact)this.obj).setVersion(version);
            } else if (this.obj instanceof Dependency) {
                ((Dependency)this.obj).setVersion(version);
            } else {
                throw new AssertionError((Object)this.obj.getClass().getName());
            }
            this.version = version;
        }

        public void setArtifactId(String artifactId) {
            if (this.obj instanceof Artifact) {
                ((Artifact)this.obj).setArtifactId(artifactId);
            } else if (this.obj instanceof Dependency) {
                ((Dependency)this.obj).setArtifactId(artifactId);
            } else {
                throw new AssertionError((Object)this.obj.getClass().getName());
            }
            this.artifactId = artifactId;
        }

        public Object unwrap() {
            return this.obj;
        }

        public String toString() {
            return this.obj.getClass().getSimpleName() + "(" + this.groupId + "." + this.artifactId + " " + this.version + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessResult {
        private final Collection<Wrapper> processedItems;
        private final Wrapper runtime;
        private final Wrapper tim;

        ProcessResult(Collection<Wrapper> processedItems, Wrapper tim, Wrapper runtime) {
            this.processedItems = processedItems;
            this.tim = tim;
            this.runtime = runtime;
        }
    }
}

