/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class SetL2ClasspathMojo
extends AbstractMojo {
    protected MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private List remoteRepositories;
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException {
        File terracottaJarFile = this.getTerracottaJar();
        if (terracottaJarFile == null) {
            throw new MojoExecutionException("Couldn't find Terracotta core artifact");
        }
        try {
            String l2Classppath = this.getTerracottaClassPath(terracottaJarFile);
            if (Boolean.valueOf(this.project.getProperties().getProperty("devmode")).booleanValue()) {
                l2Classppath = this.generateDevModeClasspath(terracottaJarFile) + l2Classppath;
            }
            this.getLog().debug((CharSequence)("Setting tc.tests.info.l2.classpath to: " + l2Classppath));
            this.project.getProperties().put("tc.tests.info.l2.classpath", l2Classppath);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error trying to find L2 classpath", e);
        }
    }

    private File getTerracottaJar() {
        Set artifacts = this.project.getDependencyArtifacts();
        for (Artifact a : artifacts) {
            if (!a.getArtifactId().equals("terracotta") && !a.getArtifactId().equals("terracotta-ee") || !a.getGroupId().equals("org.terracotta")) continue;
            return a.getFile();
        }
        return null;
    }

    private File getArtifactFile(String artifactCoordinate) throws Exception {
        String[] coords = artifactCoordinate.split(":");
        if (coords.length != 4) {
            throw new RuntimeException("Coordinate doesn't match template [groupId:artifactId:version:type]: " + artifactCoordinate);
        }
        String groupId = coords[0];
        String artifactId = coords[1];
        String version = coords[2];
        String type = coords[3];
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "test", type);
        this.getLog().debug((CharSequence)("XXX resolving L2 classpath element " + artifactCoordinate));
        this.artifactResolver.resolveAlways(artifact, this.remoteRepositories, this.localRepository);
        File artifactFile = new File(this.localRepository.getBasedir(), groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "." + type);
        if (!artifactFile.exists()) {
            throw new RuntimeException("Failed to resolve artifact: " + artifactCoordinate);
        }
        return artifactFile.getCanonicalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTerracottaClassPath(File terracottaJar) throws Exception {
        String string;
        Manifest manifest = null;
        FileInputStream in = null;
        try {
            String[] classpathElements;
            in = new FileInputStream(terracottaJar);
            JarInputStream jarStream = new JarInputStream(in);
            manifest = jarStream.getManifest();
            jarStream.close();
            String mavenClassPath = manifest.getMainAttributes().getValue("Maven-Class-Path");
            if (mavenClassPath == null) {
                throw new Exception("Coudln't find Maven-Class-Path in manifest of " + terracottaJar);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(terracottaJar);
            for (String element : classpathElements = mavenClassPath.split(" ")) {
                File path = this.getArtifactFile(element);
                if (path == null) continue;
                sb.append(File.pathSeparator).append(path.getAbsolutePath());
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    private String generateDevModeClasspath(File terracottaJarFile) throws IOException {
        String string;
        ZipFile zip = new ZipFile(terracottaJarFile);
        ZipEntry devmodeClassDir = zip.getEntry("devmode-classdir.txt");
        if (devmodeClassDir == null) {
            this.getLog().warn((CharSequence)("devmode is on but couldn't find devmode-classdir.txt inside terracotta jar" + terracottaJarFile));
            zip.close();
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(zip.getInputStream(devmodeClassDir)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                for (String part : line.split(File.pathSeparator)) {
                    String path = part.trim();
                    if (path.length() == 0) continue;
                    File file = new File(path);
                    sb.append(file.getCanonicalPath()).append(File.pathSeparator);
                }
            }
            string = sb.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                zip.close();
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        zip.close();
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }
}

