/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;

public class PrepareToolkitContentMojo
extends AbstractMojo {
    private static final String EMBEDDED_JARS_REGEX = PrepareToolkitContentMojo.createToolkitEmbeddedJarsRegex();
    private static final Pattern EMBEDDED_JARS_PATTERN = Pattern.compile(EMBEDDED_JARS_REGEX);
    protected MavenProject project;
    private File packagingDir;
    private String privateClassSuffix;
    private String toolkitContentFilename;
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping toolkit content packaging");
            return;
        }
        if (!this.packagingDir.exists()) {
            throw new MojoExecutionException("Packaging dir not found: " + this.packagingDir);
        }
        File entriesFile = new File(this.packagingDir, this.toolkitContentFilename);
        if (entriesFile.exists()) {
            this.getLog().info((CharSequence)"Embedded jars have been exploded... skipping");
            return;
        }
        try {
            StringBuilder internalJars = new StringBuilder();
            Iterator it = FileUtils.iterateFiles((File)this.packagingDir, (String[])new String[]{"jar"}, (boolean)true);
            while (it.hasNext()) {
                File jar = (File)it.next();
                Matcher m = EMBEDDED_JARS_PATTERN.matcher(jar.getAbsolutePath());
                if (!m.matches()) continue;
                this.getLog().info((CharSequence)("Exploding " + jar));
                internalJars.append(m.group(1).replace('\\', '/')).append("\n");
                String name = jar.getName();
                File renamedJar = new File(jar.getParent(), name + ".tmp");
                this.ensureRename(jar, renamedJar);
                this.ensureMkdirs(jar);
                this.unzip(jar, renamedJar);
                this.ensureDelete(renamedJar);
            }
            if (this.privateClassSuffix != null) {
                this.getLog().info((CharSequence)("Renaming private classes to use suffix " + this.privateClassSuffix));
                for (String subDir : Arrays.asList("ehcache", "L1", "TIMs")) {
                    File dir = new File(this.packagingDir, subDir);
                    if (!dir.isDirectory()) continue;
                    it = FileUtils.iterateFiles((File)dir, (String[])new String[]{"class"}, (boolean)true);
                    while (it.hasNext()) {
                        File classFile = (File)it.next();
                        File clazzFile = new File(classFile.getParentFile(), classFile.getName().replace(".class", this.privateClassSuffix));
                        classFile.renameTo(clazzFile);
                    }
                }
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(entriesFile);
                pw.print(internalJars.toString());
                pw.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO error", (Exception)e);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error", (Exception)e);
        }
    }

    private void unzip(File dest, File source) {
        Project dummyProject = new Project();
        dummyProject.init();
        Expand unzip = new Expand();
        unzip.setProject(dummyProject);
        unzip.setDest(dest);
        unzip.setSrc(source);
        unzip.execute();
    }

    private void ensureDelete(File f) throws IOException {
        if (!f.delete()) {
            throw new IOException("Failed to delete file " + f);
        }
    }

    private void ensureMkdirs(File f) throws IOException {
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new IOException("Failed to mkdirs " + f);
        }
    }

    private void ensureRename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename " + from + " to " + to);
        }
        from.delete();
    }

    private static String createToolkitEmbeddedJarsRegex() {
        String pathRegex = "[\\\\/]";
        String notPathRegex = "[^\\\\/]";
        return ".*" + pathRegex + "?(((ehcache)|(L1)|(TIMs))" + pathRegex + notPathRegex + "+\\.jar)" + pathRegex + "?";
    }
}

