/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.sequence;

import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.xml.bind.DatatypeConverter;
import org.terracotta.management.sequence.Sequence;

public final class BoundaryFlakeSequence
implements Sequence,
Serializable {
    private final long timestamp;
    private final long nodeId;
    private final long sequence;

    BoundaryFlakeSequence(long timestamp, long nodeId, long sequence) {
        this.timestamp = timestamp;
        this.nodeId = nodeId;
        this.sequence = sequence;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getSequenceId() {
        return this.sequence;
    }

    @Override
    public String toHexString() {
        return DatatypeConverter.printHexBinary((byte[])this.toBytes());
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(24);
        buffer.putLong(this.timestamp);
        buffer.putLong(this.nodeId);
        buffer.putLong(this.sequence);
        return buffer.array();
    }

    public String toString() {
        return this.toHexString();
    }

    @Override
    public int compareTo(Sequence o) {
        long d = this.timestamp - o.getTimestamp();
        if (d == 0L && (d = this.nodeId - o.getNodeId()) == 0L) {
            d = this.sequence - o.getSequenceId();
        }
        return (int)d;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundaryFlakeSequence that = (BoundaryFlakeSequence)o;
        return this.timestamp == that.timestamp && this.nodeId == that.nodeId && this.sequence == that.sequence;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    public static BoundaryFlakeSequence fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long timestamp = buffer.getLong();
        long nodeId = buffer.getLong();
        long sequence = buffer.getLong();
        return new BoundaryFlakeSequence(timestamp, nodeId, sequence);
    }

    public static BoundaryFlakeSequence fromHexString(String hex) {
        return BoundaryFlakeSequence.fromBytes(DatatypeConverter.parseHexBinary((String)hex));
    }
}

