/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.nms.client;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.entity.nms.client.IllegalManagementCallException;
import org.terracotta.management.entity.nms.client.ManagementCall;
import org.terracotta.management.model.context.Context;

public class VoltronManagementCall<T>
implements ManagementCall<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltronManagementCall.class);
    private final CompletableFuture<T> future = new CompletableFuture();
    private final Context target;
    private final String managementCallId;
    private final Class<T> returnType;
    private final long timeout;
    private final Consumer<VoltronManagementCall<?>> onDone;

    public VoltronManagementCall(String managementCallId, Context target, Class<T> returnType, long timeout, Consumer<VoltronManagementCall<?>> onDone) {
        this.target = Objects.requireNonNull(target);
        this.managementCallId = Objects.requireNonNull(managementCallId);
        this.returnType = Objects.requireNonNull(returnType);
        this.timeout = timeout;
        this.onDone = Objects.requireNonNull(onDone);
    }

    @Override
    public T waitForReturn() throws TimeoutException, ExecutionException, InterruptedException, CancellationException, IllegalManagementCallException {
        try {
            return this.future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.cancel();
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalManagementCallException) {
                throw (IllegalManagementCallException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public Context getTarget() {
        return this.target;
    }

    @Override
    public String getId() {
        return this.managementCallId;
    }

    @Override
    public boolean isCanceled() {
        return this.future.isCancelled();
    }

    @Override
    public CompletionStage<T> asCompletionStage() {
        return this.future;
    }

    @Override
    public void cancel() {
        if (!this.future.isDone()) {
            LOGGER.trace("[{}] cancel()", (Object)this.managementCallId);
            this.future.cancel(true);
            this.onDone.accept(this);
        }
    }

    void completeExceptionally(Throwable throwable) {
        if (!this.future.isDone()) {
            LOGGER.trace("[{}] completeExceptionally({})", (Object)this.managementCallId, (Object)throwable.getClass().getName());
            this.future.completeExceptionally(throwable);
            this.onDone.accept(this);
        }
    }

    void complete(T value) {
        if (!this.future.isDone()) {
            LOGGER.trace("[{}] complete()", (Object)this.managementCallId);
            this.future.complete(value);
            this.onDone.accept(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ManagementCall{");
        sb.append("target=").append(this.target);
        sb.append(", managementCallId='").append(this.managementCallId).append('\'');
        sb.append(", returnType=").append(this.returnType);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoltronManagementCall that = (VoltronManagementCall)o;
        return this.managementCallId.equals(that.managementCallId);
    }

    public int hashCode() {
        return this.managementCallId.hashCode();
    }
}

