/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.nms.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.terracotta.management.entity.nms.client.ManagementCall;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.cluster.Cluster;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.message.Message;

public interface NmsService {
    public static final Comparator<Message> MESSAGE_COMPARATOR = Comparator.comparing(Message::getSequence);

    public NmsService setOperationTimeout(long var1, TimeUnit var3);

    public Cluster readTopology() throws TimeoutException, InterruptedException, ExecutionException;

    public Message waitForMessage() throws InterruptedException;

    public Message waitForMessage(long var1, TimeUnit var3) throws InterruptedException, TimeoutException;

    public List<Message> readMessages();

    default public List<Message> waitForMessage(Predicate<Message> predicate) throws InterruptedException {
        Message message;
        ArrayList<Message> collected = new ArrayList<Message>();
        do {
            message = this.waitForMessage();
            collected.add(message);
        } while (!predicate.test(message));
        collected.sort(MESSAGE_COMPARATOR);
        return collected;
    }

    default public ManagementCall<Void> startStatisticCollector(Context context, long interval, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.call(context, "StatisticCollectorCapability", "startStatisticCollector", Void.TYPE, new Parameter((Object)interval, Long.TYPE.getName()), new Parameter((Object)unit, TimeUnit.class.getName()));
    }

    default public ManagementCall<Void> stopStatisticCollector(Context context) throws InterruptedException, ExecutionException, TimeoutException {
        return this.call(context, "StatisticCollectorCapability", "stopStatisticCollector", Void.TYPE, new Parameter[0]);
    }

    public <T> ManagementCall<T> call(Context var1, String var2, String var3, Class<T> var4, Parameter ... var5) throws InterruptedException, ExecutionException, TimeoutException;

    public void cancelAllManagementCalls();
}

