/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.nms.client;

import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.management.entity.nms.NmsConfig;
import org.terracotta.management.entity.nms.NmsVersion;
import org.terracotta.management.entity.nms.client.NmsEntity;

public class NmsEntityFactory {
    private final Connection connection;
    private final String entityName;

    public NmsEntityFactory(Connection connection, String entityName) {
        this.connection = connection;
        this.entityName = entityName;
    }

    public NmsEntity retrieveOrCreate(NmsConfig config) throws EntityConfigurationException {
        try {
            return this.retrieve();
        }
        catch (EntityNotFoundException e) {
            try {
                return this.create(config);
            }
            catch (EntityAlreadyExistsException f) {
                try {
                    return this.retrieve();
                }
                catch (EntityNotFoundException e1) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    public NmsEntity retrieve() throws EntityNotFoundException {
        try {
            return (NmsEntity)this.getEntityRef().fetchEntity(null);
        }
        catch (EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    public NmsEntity create(NmsConfig config) throws EntityAlreadyExistsException, EntityConfigurationException {
        EntityRef<NmsEntity, NmsConfig, Object> ref = this.getEntityRef();
        try {
            ref.create((Object)config);
            return (NmsEntity)ref.fetchEntity(null);
        }
        catch (EntityNotFoundException | EntityNotProvidedException | EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    private EntityRef<NmsEntity, NmsConfig, Object> getEntityRef() {
        try {
            return this.connection.getEntityRef(NmsEntity.class, NmsVersion.LATEST.version(), this.entityName);
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

