/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.nms.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.entity.nms.client.IllegalManagementCallException;
import org.terracotta.management.entity.nms.client.ManagementCall;
import org.terracotta.management.entity.nms.client.NmsEntity;
import org.terracotta.management.entity.nms.client.NmsService;
import org.terracotta.management.entity.nms.client.VoltronManagementCall;
import org.terracotta.management.model.call.ContextualReturn;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.cluster.Cluster;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.message.ManagementCallMessage;
import org.terracotta.management.model.message.Message;

public class DefaultNmsService
implements NmsService,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NmsService.class);
    private final NmsEntity entity;
    private final BlockingQueue<Optional<Message>> incomingMessageQueue;
    private final ConcurrentMap<String, CompletableFuture<ContextualReturn<?>>> managementCallAnswers = new ConcurrentHashMap();
    private long timeout = 5000L;

    public DefaultNmsService(NmsEntity entity) {
        this(entity, new LinkedBlockingQueue<Optional<Message>>());
    }

    public DefaultNmsService(NmsEntity entity, BlockingQueue<Optional<Message>> incomingMessageQueue) {
        this(entity, incomingMessageQueue, message -> LOGGER.warn("Queue is full - Message lost: {}", message));
    }

    public DefaultNmsService(NmsEntity entity, BlockingQueue<Optional<Message>> incomingMessageQueue, Consumer<Message> sink) {
        Objects.requireNonNull(sink);
        this.entity = Objects.requireNonNull(entity);
        this.incomingMessageQueue = Objects.requireNonNull(incomingMessageQueue);
        this.entity.registerMessageListener(Message.class, message -> {
            LOGGER.trace("onMessage({})", message);
            switch (message.getType()) {
                case "MANAGEMENT_CALL_RETURN": {
                    String managementCallIdentifier = ((ManagementCallMessage)message).getManagementCallIdentifier();
                    ContextualReturn contextualReturn = (ContextualReturn)message.unwrap(ContextualReturn.class).get(0);
                    this.getManagementAnswerFor(managementCallIdentifier).complete(contextualReturn);
                    break;
                }
                case "NOTIFICATION": 
                case "STATISTICS": {
                    boolean offered = incomingMessageQueue.offer(Optional.of(message));
                    if (offered) break;
                    sink.accept((Message)message);
                    break;
                }
                default: {
                    LOGGER.warn("Received unsupported message: " + message);
                }
            }
        });
    }

    public NmsEntity getEntity() {
        return this.entity;
    }

    @Override
    public void close() {
        this.cancelAllManagementCalls();
        this.entity.close();
    }

    @Override
    public NmsService setOperationTimeout(long duration, TimeUnit unit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(duration, unit);
        return this;
    }

    @Override
    public Cluster readTopology() throws TimeoutException, InterruptedException, ExecutionException {
        return (Cluster)this.get(this.entity.readTopology());
    }

    @Override
    public Message waitForMessage() throws InterruptedException {
        Optional<Message> o = this.incomingMessageQueue.take();
        if (!o.isPresent()) {
            throw new InterruptedException();
        }
        return o.get();
    }

    @Override
    public Message waitForMessage(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        Optional<Message> o = this.incomingMessageQueue.poll(time, unit);
        if (o == null) {
            throw new TimeoutException("No message arrived within " + time + " " + (Object)((Object)unit));
        }
        if (!o.isPresent()) {
            throw new InterruptedException();
        }
        return o.get();
    }

    @Override
    public List<Message> readMessages() {
        ArrayList optionals = new ArrayList(this.incomingMessageQueue.size());
        this.incomingMessageQueue.drainTo(optionals);
        List<Message> messages = optionals.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!messages.isEmpty()) {
            messages.sort(MESSAGE_COMPARATOR);
        }
        return messages;
    }

    @Override
    public <T> ManagementCall<T> call(Context context, String capabilityName, String methodName, Class<T> returnType, Parameter ... parameters) throws InterruptedException, ExecutionException, TimeoutException {
        LOGGER.trace("call({}, {}, {})", new Object[]{context, capabilityName, methodName});
        String managementCallId = (String)this.get(this.entity.call(null, context, capabilityName, methodName, returnType, parameters));
        VoltronManagementCall managementCall = new VoltronManagementCall(managementCallId, context, returnType, this.timeout, that -> {
            CompletableFuture cfr_ignored_0 = (CompletableFuture)this.managementCallAnswers.remove(managementCallId);
        });
        this.getManagementAnswerFor(managementCallId).whenComplete((aReturn, stopper) -> {
            if (stopper != null) {
                managementCall.completeExceptionally((Throwable)stopper);
            } else {
                try {
                    managementCall.complete(aReturn.getValue());
                }
                catch (ExecutionException e) {
                    managementCall.completeExceptionally(e.getCause());
                }
                catch (NoSuchElementException e) {
                    managementCall.completeExceptionally(new IllegalManagementCallException(aReturn.getContext(), aReturn.getCapability(), aReturn.getMethodName()));
                }
            }
        });
        return managementCall;
    }

    @Override
    public void cancelAllManagementCalls() {
        InterruptedException stopper = new InterruptedException();
        while (!this.managementCallAnswers.isEmpty()) {
            this.managementCallAnswers.keySet().forEach(k -> {
                CompletableFuture removed = (CompletableFuture)this.managementCallAnswers.remove(k);
                if (removed != null) {
                    removed.completeExceptionally(stopper);
                }
            });
        }
    }

    private <V> V get(Future<V> future) throws ExecutionException, TimeoutException, InterruptedException {
        return future.get(this.timeout, TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<ContextualReturn<?>> getManagementAnswerFor(String managementCallIdentifier) {
        return this.managementCallAnswers.computeIfAbsent(managementCallIdentifier, s -> new CompletableFuture());
    }
}

