/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.nms.agent.client.diag;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticUtility.class);
    protected static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public String getThreadDump() {
        StringBuilder sb = new StringBuilder(102400);
        sb.append(new Date().toString());
        sb.append('\n');
        sb.append("Full thread dump ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(" (");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(' ');
        sb.append(System.getProperty("java.vm.info"));
        sb.append("):\n\n");
        try {
            ThreadInfo[] threadsInfo;
            for (ThreadInfo threadInfo : threadsInfo = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported())) {
                DiagnosticUtility.threadHeader(sb, threadInfo);
                StackTraceElement[] stea = threadInfo.getStackTrace();
                MonitorInfo[] monitorInfos = threadInfo.getLockedMonitors();
                for (StackTraceElement element : stea) {
                    sb.append("\tat ");
                    sb.append(element.toString());
                    sb.append('\n');
                    for (MonitorInfo monitorInfo : monitorInfos) {
                        StackTraceElement lockedFrame = monitorInfo.getLockedStackFrame();
                        if (lockedFrame == null || !lockedFrame.equals(element)) continue;
                        sb.append("\t- locked <0x");
                        sb.append(Integer.toHexString(monitorInfo.getIdentityHashCode()));
                        sb.append("> (a ");
                        sb.append(monitorInfo.getClassName());
                        sb.append(")");
                        sb.append('\n');
                    }
                }
                if (!threadMXBean.isObjectMonitorUsageSupported() && threadMXBean.isSynchronizerUsageSupported()) {
                    sb.append(DiagnosticUtility.threadLockedSynchronizers(threadInfo));
                }
                sb.append('\n');
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot take thread dumps - " + e.getMessage(), (Throwable)e);
            sb.append(e.toString());
        }
        return sb.toString();
    }

    private static void threadHeader(StringBuilder sb, ThreadInfo threadInfo) {
        String threadName = threadInfo.getThreadName();
        sb.append("\"");
        sb.append(threadName);
        sb.append("\" ");
        sb.append("Id=");
        sb.append(threadInfo.getThreadId());
        try {
            Thread.State threadState = threadInfo.getThreadState();
            String lockName = threadInfo.getLockName();
            String lockOwnerName = threadInfo.getLockOwnerName();
            Long lockOwnerId = threadInfo.getLockOwnerId();
            Boolean isSuspended = threadInfo.isSuspended();
            Boolean isInNative = threadInfo.isInNative();
            sb.append(" ");
            sb.append((Object)threadState);
            if (lockName != null) {
                sb.append(" on ");
                sb.append(lockName);
            }
            if (lockOwnerName != null) {
                sb.append(" owned by \"");
                sb.append(lockOwnerName);
                sb.append("\" Id=");
                sb.append(lockOwnerId);
            }
            if (isSuspended.booleanValue()) {
                sb.append(" (suspended)");
            }
            if (isInNative.booleanValue()) {
                sb.append(" (in native)");
            }
        }
        catch (Exception e) {
            sb.append(" ( Got exception : ").append(e.getMessage()).append(" :");
        }
        sb.append('\n');
    }

    private static String threadLockedSynchronizers(ThreadInfo threadInfo) {
        String NO_SYNCH_INFO = "no locked synchronizers information available\n";
        if (null == threadInfo) {
            return "no locked synchronizers information available\n";
        }
        try {
            LockInfo[] lockInfos = threadInfo.getLockedSynchronizers();
            if (lockInfos.length > 0) {
                StringBuffer lockedSynchBuff = new StringBuffer();
                lockedSynchBuff.append("\nLocked Synchronizers: \n");
                for (LockInfo lockInfo : lockInfos) {
                    lockedSynchBuff.append(lockInfo.getClassName()).append(" <").append(lockInfo.getIdentityHashCode()).append("> \n");
                }
                return lockedSynchBuff.append("\n").toString();
            }
            return "";
        }
        catch (Exception e) {
            return "no locked synchronizers information available\n";
        }
    }
}

