/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.nms.agent.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;
import org.terracotta.management.entity.nms.agent.ReconnectData;
import org.terracotta.management.entity.nms.agent.client.NmsAgentEntity;
import org.terracotta.management.entity.nms.agent.client.NmsAgentEntityFactory;
import org.terracotta.management.entity.nms.agent.client.NmsAgentService;
import org.terracotta.management.entity.nms.agent.client.diag.DiagnosticProvider;
import org.terracotta.management.entity.nms.agent.client.diag.DiagnosticUtility;
import org.terracotta.management.model.call.ContextualCall;
import org.terracotta.management.model.call.ContextualReturn;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.ContextContainer;
import org.terracotta.management.model.message.ManagementCallMessage;
import org.terracotta.management.model.message.Message;
import org.terracotta.management.model.notification.ContextualNotification;
import org.terracotta.management.model.stats.ContextualStatistics;
import org.terracotta.management.registry.CallQuery;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.ManagementProviderAdapter;
import org.terracotta.management.registry.ManagementRegistry;
import org.terracotta.voltron.proxy.MessageListener;
import org.terracotta.voltron.proxy.client.EndpointListener;

public class DefaultNmsAgentService
implements EndpointListener,
MessageListener<Message>,
NmsAgentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNmsAgentService.class);
    private static final String CAPABILITY_NAME = NmsAgentService.class.getSimpleName();
    private final Supplier<NmsAgentEntity> entitySupplier;
    private final Context root;
    private volatile boolean closed;
    private volatile NmsAgentEntity entity;
    private volatile ManagementRegistry registry;
    private volatile String[] previouslyExposedTags;
    private long timeoutMs = 5000L;
    private Executor managementCallExecutor = Runnable::run;
    private final ManagementProvider<?> diagnosticProvider = new DiagnosticProvider(DiagnosticUtility.class);
    private BiConsumer<Operation, Throwable> onOperationError = (op, err) -> LOGGER.trace("Failed to call management entity. Message will be lost. Error: {}", (Object)err.getMessage(), err);
    private final ManagementProvider<?> managementProvider = new ManagementProviderAdapter<Object>(CAPABILITY_NAME, Object.class){

        public void register(Object managedObject) {
            DefaultNmsAgentService.this.refreshManagementRegistry();
        }

        public void unregister(Object managedObject) {
            DefaultNmsAgentService.this.refreshManagementRegistry();
        }
    };

    public DefaultNmsAgentService(Context root, NmsAgentEntity entity) {
        this(root, () -> entity);
    }

    public DefaultNmsAgentService(Context root, Connection connection) {
        this(root, new NmsAgentEntityFactory(connection).retrieve());
    }

    public DefaultNmsAgentService(Context root, Supplier<NmsAgentEntity> entitySupplier) {
        this.root = root;
        this.entitySupplier = entitySupplier;
    }

    public void onMessage(Message message) {
        LOGGER.trace("onMessage({})", (Object)message);
        if (message.getType().equals("MANAGEMENT_CALL")) {
            ContextualCall contextualCall = (ContextualCall)message.unwrap(ContextualCall.class).get(0);
            this.getManagementCallExecutor().execute(() -> this.executeManagementCall(((ManagementCallMessage)message).getManagementCallIdentifier(), contextualCall));
        } else {
            LOGGER.warn("Received unsupported message: " + message);
        }
    }

    public Object onReconnect() {
        if (this.isManagementRegistryBridged()) {
            Context context;
            ManagementRegistry registry = this.getRegistry();
            Collection<Object> capabilities = registry == null ? Collections.emptyList() : registry.getCapabilities();
            Context context2 = context = registry == null ? Context.empty() : this.root.with(registry.getContextContainer().getName(), registry.getContextContainer().getValue());
            if (registry == null) {
                LOGGER.info("Reconnecting current client with tags: " + Arrays.toString(this.previouslyExposedTags));
            } else {
                LOGGER.info("Reconnecting current client with existing management registry and tags: " + Arrays.toString(this.previouslyExposedTags));
            }
            return new ReconnectData(this.previouslyExposedTags, this.root, registry == null ? null : registry.getContextContainer(), registry == null ? null : capabilities.toArray(new Capability[capabilities.size()]), new ContextualNotification(context, "CLIENT_RECONNECTED"));
        }
        return null;
    }

    public void onDisconnectUnexpectedly() {
        LOGGER.info("Management entity will be flushed following an unexpected disconnection");
        this.flushEntity();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            LOGGER.info("Closing management agent service");
            ManagementRegistry registry = this.getRegistry();
            if (registry != null) {
                registry.removeManagementProvider(this.managementProvider);
                this.registry = null;
            }
            this.flushEntity();
            this.closed = true;
        }
    }

    @Override
    public boolean isDisconnected() {
        return this.entity == null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setManagementRegistry(ManagementRegistry registry) {
        LOGGER.trace("setManagementRegistry({})", (Object)registry.getContextContainer().getValue());
        if (this.registry == null) {
            boolean alreadybridged;
            boolean bl = alreadybridged = !registry.getManagementProvidersByCapability("DiagnosticCalls").isEmpty();
            if (!alreadybridged) {
                registry.addManagementProvider(this.diagnosticProvider);
                registry.register((Object)new DiagnosticUtility());
            }
            if (!(alreadybridged = registry.getManagementProvidersByCapability(CAPABILITY_NAME).stream().anyMatch(provider -> provider == this.managementProvider))) {
                registry.addManagementProvider(this.managementProvider);
            }
            this.registry = registry;
        }
    }

    public ManagementRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public boolean isManagementRegistryBridged() {
        return this.registry != null;
    }

    public NmsAgentService setManagementCallExecutor(Executor managementCallExecutor) {
        this.managementCallExecutor = Objects.requireNonNull(managementCallExecutor);
        return this;
    }

    public Executor getManagementCallExecutor() {
        return this.managementCallExecutor;
    }

    public NmsAgentService setOperationTimeout(long duration, TimeUnit unit) {
        this.timeoutMs = TimeUnit.MILLISECONDS.convert(duration, unit);
        return this;
    }

    public void setOnOperationError(BiConsumer<Operation, Throwable> onOperationError) {
        this.onOperationError = onOperationError;
    }

    @Override
    public void setCapabilities(ContextContainer contextContainer, Collection<? extends Capability> capabilities) {
        this.setCapabilities(contextContainer, capabilities.toArray(new Capability[capabilities.size()]));
    }

    @Override
    public void setCapabilities(ContextContainer contextContainer, Capability ... capabilities) {
        LOGGER.trace("exposeManagementMetadata({})", (Object)contextContainer.getValue());
        this.runOperation(() -> this.getEntity().exposeManagementMetadata(null, this.root, contextContainer, capabilities));
    }

    @Override
    public void setTags(Collection<String> tags) {
        this.setTags(tags.toArray(new String[tags.size()]));
    }

    @Override
    public void setTags(String ... tags) {
        LOGGER.trace("setTags({})", Arrays.asList(tags));
        this.runOperation(() -> this.getEntity().exposeTags(null, tags));
        this.previouslyExposedTags = tags;
    }

    @Override
    public void pushNotification(ContextualNotification notification) {
        if (notification != null) {
            notification.setContext(notification.getContext().with((Map)this.root));
            LOGGER.trace("pushNotification({})", (Object)notification);
            this.runOperation(() -> this.getEntity().pushNotification(null, notification));
        }
    }

    @Override
    public void pushStatistics(Collection<ContextualStatistics> statistics) {
        this.pushStatistics(statistics.toArray(new ContextualStatistics[statistics.size()]));
    }

    @Override
    public void pushStatistics(ContextualStatistics ... statistics) {
        if (statistics.length > 0) {
            for (ContextualStatistics statistic : statistics) {
                statistic.setContext(statistic.getContext().with((Map)this.root));
            }
            LOGGER.trace("pushStatistics({})", (Object)statistics.length);
            this.runOperation(() -> this.getEntity().pushStatistics(null, statistics));
        }
    }

    @Override
    public void sendStates() {
        LOGGER.info("Sending management registry and tags to server");
        this.refreshManagementRegistry();
        if (this.previouslyExposedTags != null) {
            this.setTags(this.previouslyExposedTags);
        }
    }

    @Override
    public void flushEntity() {
        NmsAgentEntity entity = this.entity;
        this.entity = null;
        if (entity != null) {
            LOGGER.trace("flushEntity()");
            entity.setEndpointListener(null);
        }
    }

    public void refreshManagementRegistry() {
        if (this.isManagementRegistryBridged()) {
            ManagementRegistry registry = this.getRegistry();
            this.setCapabilities(registry.getContextContainer(), registry.getCapabilities());
        }
    }

    protected void executeManagementCall(String managementCallIdentifier, ContextualCall<?> contextualCall) {
        if (this.isManagementRegistryBridged()) {
            ContextualReturn aReturn = (ContextualReturn)((CallQuery)((CallQuery.Builder)this.getRegistry().withCapability(contextualCall.getCapability()).call(contextualCall.getMethodName(), contextualCall.getReturnType(), contextualCall.getParameters()).on(contextualCall.getContext())).build()).execute().getSingleResult();
            this.answerManagementCall(managementCallIdentifier, aReturn);
        }
    }

    protected void answerManagementCall(String managementCallIdentifier, ContextualReturn<?> aReturn) {
        LOGGER.trace("answerManagementCall({}, {})", (Object)managementCallIdentifier, aReturn);
        aReturn.setContext(aReturn.getContext().with((Map)this.root));
        this.runOperation(() -> this.getEntity().answerManagementCall(null, managementCallIdentifier, aReturn));
    }

    protected void runOperation(Supplier<Future<?>> op) {
        if (!this.isClosed()) {
            Future<?> future;
            try {
                future = op.get();
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                this.flushEntity();
                this.onOperationError.accept(() -> this.runOperation(op), e);
                return;
            }
            try {
                future.get(this.timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.onOperationError.accept(() -> this.runOperation(op), e.getCause());
            }
            catch (RuntimeException | TimeoutException e) {
                this.onOperationError.accept(() -> this.runOperation(op), e);
            }
        }
    }

    protected NmsAgentEntity getEntity() {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        NmsAgentEntity entity = this.entity;
        if (entity != null) {
            return entity;
        }
        LOGGER.info("Creating new management agent entity");
        entity = Objects.requireNonNull(this.entitySupplier.get());
        entity.registerMessageListener(Message.class, this);
        entity.setEndpointListener(this);
        this.entity = entity;
        this.refreshManagementRegistry();
        if (this.previouslyExposedTags != null) {
            this.setTags(this.previouslyExposedTags);
        }
        return entity;
    }

    public static interface Operation {
        public void retry();
    }
}

