/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.service.monitoring.registry.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.StatisticRegistry;
import org.terracotta.management.registry.ExposedObject;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;
import org.terracotta.management.sequence.TimeSource;
import org.terracotta.management.service.monitoring.registry.provider.AbstractExposedStatistics;
import org.terracotta.management.service.monitoring.registry.provider.AliasBinding;
import org.terracotta.management.service.monitoring.registry.provider.AliasBindingManagementProvider;

@RequiredContext(value={@Named(value="consumerId")})
public abstract class AbstractStatisticsManagementProvider<T extends AliasBinding>
extends AliasBindingManagementProvider<T> {
    public AbstractStatisticsManagementProvider(Class<? extends T> type) {
        super(type);
    }

    protected void dispose(ExposedObject<T> exposedObject) {
        ((AbstractExposedStatistics)exposedObject).close();
    }

    public final Collection<? extends Descriptor> getDescriptors() {
        ArrayList list = new ArrayList(super.getDescriptors());
        Collections.sort(list, STATISTIC_DESCRIPTOR_COMPARATOR);
        return list;
    }

    public Map<String, Statistic<? extends Serializable>> collectStatistics(Context context, Collection<String> statisticNames, long since) {
        AbstractExposedStatistics exposedObject = (AbstractExposedStatistics)this.findExposedObject(context);
        if (exposedObject == null) {
            return Collections.emptyMap();
        }
        return StatisticRegistry.collect((StatisticRegistry)exposedObject.getStatisticRegistry(), statisticNames, (long)since);
    }

    @Override
    protected AbstractExposedStatistics<T> wrap(T managedObject) {
        Context context = Context.empty().with("consumerId", String.valueOf(this.getMonitoringService().getConsumerId())).with("alias", ((AliasBinding)managedObject).getAlias());
        StatisticRegistry statisticRegistry = this.getStatisticRegistry(managedObject);
        return this.internalWrap(context, managedObject, statisticRegistry);
    }

    protected StatisticRegistry getStatisticRegistry(T managedObject) {
        return new StatisticRegistry(((AliasBinding)managedObject).getValue(), () -> ((TimeSource)this.getTimeSource()).getTimestamp());
    }

    @Override
    protected final AbstractExposedStatistics<T> internalWrap(Context context, T managedObject) {
        throw new UnsupportedOperationException();
    }

    protected abstract AbstractExposedStatistics<T> internalWrap(Context var1, T var2, StatisticRegistry var3);
}

