/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.service.monitoring;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.terracotta.management.model.context.ContextContainer;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.service.monitoring.EntityMonitoringService;

public interface EntityManagementRegistry
extends CapabilityManagementSupport,
Closeable {
    public EntityMonitoringService getMonitoringService();

    public ContextContainer getContextContainer();

    public boolean addManagementProvider(ManagementProvider<?> var1);

    public void removeManagementProvider(ManagementProvider<?> var1);

    public CompletableFuture<Void> register(Object var1);

    public void unregister(Object var1);

    public void refresh();

    default public void pushServerEntityNotification(Object managedObjectSource, String type) {
        this.pushServerEntityNotification(managedObjectSource, type, Collections.emptyMap());
    }

    public boolean pushServerEntityNotification(Object var1, String var2, Map<String, String> var3);

    default public CompletableFuture<Void> registerAndRefresh(Object managedObject) {
        return this.register(managedObject).thenRun(this::refresh);
    }

    default public void unregisterAndRefresh(Object managedObject) {
        this.unregister(managedObject);
        this.refresh();
    }

    @Override
    public void close();

    public void entityPromotionCompleted();

    public void entityCreated();
}

