/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.service.monitoring.registry.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.cluster.ClientIdentifier;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.ExposedObject;
import org.terracotta.management.service.monitoring.registry.provider.AbstractEntityManagementProvider;
import org.terracotta.management.service.monitoring.registry.provider.ClientBinding;

public class ClientBindingManagementProvider<T extends ClientBinding>
extends AbstractEntityManagementProvider<T> {
    public ClientBindingManagementProvider(Class<? extends T> type) {
        super(type);
    }

    @Override
    public CompletableFuture<Void> registerAsync(T managedObject) {
        ClientDescriptor clientDescriptor = ((ClientBinding)managedObject).getClientDescriptor();
        CompletableFuture<ClientIdentifier> stage = this.getMonitoringService().getClientIdentifier(clientDescriptor);
        return stage.thenCompose(clientIdentifier -> {
            managedObject.resolvedClientIdentifier = clientIdentifier;
            return super.registerAsync(managedObject);
        });
    }

    @Override
    protected ExposedClientBinding<T> wrap(T managedObject) {
        Context context = Context.create((String)"consumerId", (String)String.valueOf(this.getMonitoringService().getConsumerId())).with("alias", ((ClientBinding)managedObject).resolvedClientIdentifier.getClientId());
        return this.internalWrap(context, managedObject);
    }

    @Override
    protected ExposedClientBinding<T> internalWrap(Context context, T managedObject) {
        return new ExposedClientBinding<T>(context, managedObject);
    }

    public static class ExposedClientBinding<T extends ClientBinding>
    implements ExposedObject<T> {
        private final T clientBinding;
        private final Context context;

        public ExposedClientBinding(Context context, T clientBinding) {
            this.clientBinding = (ClientBinding)Objects.requireNonNull(clientBinding);
            this.context = Objects.requireNonNull(context);
        }

        public T getClientBinding() {
            return this.clientBinding;
        }

        public Context getContext() {
            return this.context;
        }

        public ClassLoader getClassLoader() {
            return ((ClientBinding)this.clientBinding).getValue().getClass().getClassLoader();
        }

        public T getTarget() {
            return this.clientBinding;
        }

        public Collection<? extends Descriptor> getDescriptors() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExposedClientBinding that = (ExposedClientBinding)o;
            return ((ClientBinding)this.clientBinding).equals(that.clientBinding);
        }

        public int hashCode() {
            return ((ClientBinding)this.clientBinding).hashCode();
        }
    }
}

