/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;

public final class ContextualStatistics
implements Contextual {
    private static final long serialVersionUID = 1L;
    private final Map<String, Number> statistics;
    private final String capability;
    private Context context;

    public ContextualStatistics(String capability, Context context, Map<String, Number> statistics) {
        this.statistics = new HashMap<String, Number>(Objects.requireNonNull(statistics));
        this.context = Objects.requireNonNull(context);
        this.capability = Objects.requireNonNull(capability);
    }

    public String getCapability() {
        return this.capability;
    }

    public int size() {
        return this.statistics.size();
    }

    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    public Map<String, Number> getStatistics() {
        return this.statistics;
    }

    public boolean hasStatistic(String name) {
        return this.statistics.containsKey(name);
    }

    public Number getStatistic(String name) throws NoSuchElementException {
        Number stat = this.statistics.get(name);
        if (stat == null) {
            throw new NoSuchElementException(name);
        }
        return stat;
    }

    @Override
    public void setContext(Context context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public String toString() {
        return "ContextualStatistics{capability='" + this.capability + '\'' + ", context=" + this.context + ", statistics=" + this.statistics.size() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualStatistics that = (ContextualStatistics)o;
        if (!((Object)this.statistics).equals(that.statistics)) {
            return false;
        }
        if (!this.capability.equals(that.capability)) {
            return false;
        }
        return this.context.equals(that.context);
    }

    public int hashCode() {
        int result = ((Object)this.statistics).hashCode();
        result = 31 * result + this.capability.hashCode();
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

