/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class ServiceLocator {
    private static final AtomicReference<Map<Class<?>, Object>> installedServices = new AtomicReference();
    private final Map<Class<?>, Object> services = new HashMap();

    public final <T> ServiceLocator loadService(Class<T> clazz, T implementation) {
        this.services.put(clazz, implementation);
        return this;
    }

    public static <T> T locate(Class<T> typeToReturn) {
        Map<Class<?>, Object> m = installedServices.get();
        if (m == null) {
            throw new IllegalStateException("The service locator has not been initialized yet ! (through the load() method)");
        }
        return (T)m.get(typeToReturn);
    }

    public static void load(ServiceLocator locator) {
        Map<Class<?>, Object> services = Collections.unmodifiableMap(new HashMap(locator.services));
        if (!installedServices.compareAndSet(null, services)) {
            throw new IllegalStateException("The service locator has already been initialized (through the load() method)");
        }
    }

    public static void unload() {
        installedServices.set(null);
    }
}

