/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.resource.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.terracotta.management.resource.ErrorEntity;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable t) {
        Throwable last = null;
        while (t != null && t != last) {
            last = t;
            t = t.getCause();
        }
        if (last instanceof InvocationTargetException) {
            last = ((InvocationTargetException)last).getTargetException();
        }
        return last;
    }

    public static ErrorEntity toErrorEntity(Throwable t) {
        String errorMessage = "";
        String stackTrace = null;
        if (t != null) {
            String message = t.getMessage();
            errorMessage = message == null ? "" : message.replace('\"', '\'');
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            stackTrace = sw.toString();
        }
        String extraErrorMessage = "";
        Throwable rootCause = ExceptionUtils.getRootCause(t);
        if (rootCause != t && rootCause != null && rootCause.getMessage() != null) {
            extraErrorMessage = rootCause.getMessage().replace('\"', '\'');
        }
        ErrorEntity errorEntity = new ErrorEntity();
        errorEntity.setError(errorMessage);
        errorEntity.setDetails(extraErrorMessage);
        errorEntity.setStackTrace(stackTrace);
        return errorEntity;
    }
}

