/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.l1bridge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.l1bridge.RemoteAgentEndpoint;
import org.terracotta.management.l1bridge.RemoteCallDescriptor;
import org.terracotta.management.l1bridge.RemoteCallException;

public abstract class AbstractRemoteAgentEndpointImpl
implements RemoteAgentEndpoint {
    @Override
    public byte[] invoke(RemoteCallDescriptor remoteCallDescriptor) throws RemoteCallException {
        String serviceName = remoteCallDescriptor.getServiceName();
        try {
            Class<?> serviceClass = Class.forName(serviceName);
            Object service = ServiceLocator.locate(serviceClass);
            if (service == null) {
                throw new RemoteCallException("No such service registered in ServiceLocator: " + serviceName);
            }
            Method method = service.getClass().getMethod(remoteCallDescriptor.getMethodName(), remoteCallDescriptor.getParamClasses());
            Object returnValue = method.invoke(service, remoteCallDescriptor.getParams());
            return AbstractRemoteAgentEndpointImpl.serialize(returnValue);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RemoteCallException("Service class does not exist: " + serviceName, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new RemoteCallException("Service does not implement method " + AbstractRemoteAgentEndpointImpl.fullMethodName(remoteCallDescriptor), nsme);
        }
        catch (IllegalAccessException iae) {
            throw new RemoteCallException("Error accessing method " + AbstractRemoteAgentEndpointImpl.fullMethodName(remoteCallDescriptor), iae);
        }
        catch (InvocationTargetException ite) {
            throw new RemoteCallException("Error invoking remote method " + AbstractRemoteAgentEndpointImpl.fullMethodName(remoteCallDescriptor), ite);
        }
        catch (IOException ioe) {
            throw new RemoteCallException("Error serializing return value of " + AbstractRemoteAgentEndpointImpl.fullMethodName(remoteCallDescriptor), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    private static String fullMethodName(RemoteCallDescriptor remoteCallDescriptor) {
        return remoteCallDescriptor.getServiceName() + "." + remoteCallDescriptor.getMethodName() + "()";
    }
}

