/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.embedded;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.terracotta.management.resource.ErrorEntity;
import org.terracotta.management.resource.exceptions.ExceptionUtils;

public class NoIaFilter
implements Filter {
    private static final String REQ_TICKET = "req-ticket";
    private static final String TC_ID_TOKEN = "tc-identity-token";
    private static final String ALIAS = "alias";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getHeader(REQ_TICKET) != null || httpServletRequest.getHeader(TC_ID_TOKEN) != null || httpServletRequest.getHeader(ALIAS) != null) {
            httpServletResponse.setContentType("application/json");
            ErrorEntity jsonError = ExceptionUtils.toErrorEntity((Throwable)new ServletException("Request cannot contain security headers"));
            httpServletResponse.getWriter().print(jsonError.toJSON());
            httpServletResponse.setStatus(400);
            return;
        }
        chain.doFilter(request, response);
    }
}

