/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services.utils;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.jersey.uri.UriComponent;

public class UriUtils {
    private static final Set<String> DEFAULT_QUERY_PARAMS_TO_SANITIZE = new HashSet<String>();
    public static final String MASK = "XXXXX";

    public static URI sanitizeQueryParams(URI uri, boolean shouldMask, Set<String> queryParams) {
        if (uri == null) {
            return null;
        }
        Set all = UriComponent.decodeQuery((URI)uri, (boolean)false).keySet();
        Set toSanitize = queryParams.stream().filter(all::contains).collect(Collectors.toSet());
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        for (String queryParam : toSanitize) {
            if (shouldMask) {
                uriBuilder.replaceQueryParam(queryParam, new Object[]{MASK});
                continue;
            }
            uriBuilder.replaceQueryParam(queryParam, new Object[0]);
        }
        return uriBuilder.build(new Object[0]);
    }

    public static URI removeQueryParams(URI uri, Set<String> queryParams) {
        return UriUtils.sanitizeQueryParams(uri, false, queryParams);
    }

    public static URI removeQueryParams(URI uri) {
        return UriUtils.removeQueryParams(uri, DEFAULT_QUERY_PARAMS_TO_SANITIZE);
    }

    public static URI maskQueryParams(URI uri, Set<String> queryParams) {
        return UriUtils.sanitizeQueryParams(uri, true, queryParams);
    }

    public static URI maskQueryParams(URI uri) {
        return UriUtils.maskQueryParams(uri, DEFAULT_QUERY_PARAMS_TO_SANITIZE);
    }

    static {
        DEFAULT_QUERY_PARAMS_TO_SANITIZE.add("username");
        DEFAULT_QUERY_PARAMS_TO_SANITIZE.add("password");
    }
}

