/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lcp;

import com.tc.lcp.HeartBeatService;
import com.tc.lcp.LinkedJavaProcessStarter;
import com.tc.lcp.StreamCopier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedJavaProcess
extends Process {
    private File javaHome;
    private final String mainClassName;
    private final List<String> javaArguments;
    private final List<String> arguments;
    private List<String> environment;
    private File directory;
    private File javaExecutable;
    private long maxRuntime = 900L;
    private String classpath;
    private String[] command;
    private Process process;
    private boolean running;
    private boolean addL1Repos = true;
    private final List<StreamCopier> copiers = Collections.synchronizedList(new ArrayList());

    public LinkedJavaProcess(String mainClassName, List<String> classArguments, List<String> jvmArgs) {
        this.mainClassName = mainClassName;
        this.javaArguments = jvmArgs == null ? new ArrayList() : jvmArgs;
        this.arguments = classArguments == null ? new ArrayList() : classArguments;
        this.environment = new ArrayList<String>();
        this.directory = null;
        this.javaExecutable = null;
        this.process = null;
        this.running = false;
    }

    public LinkedJavaProcess(String mainClassName) {
        this(mainClassName, new ArrayList<String>(), new ArrayList<String>());
    }

    public LinkedJavaProcess(String mainClassName, List<String> classArguments) {
        this(mainClassName, classArguments, new ArrayList<String>());
    }

    public void setMaxRuntime(long maxRuntime) {
        this.maxRuntime = maxRuntime;
    }

    public long getMaxRuntime() {
        return this.maxRuntime;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public void setJavaExecutable(File javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public void addAllJvmArgs(List<String> jvmArgs) {
        this.javaArguments.addAll(jvmArgs);
    }

    public void addJvmArg(String jvmArg) {
        this.javaArguments.add(jvmArg);
    }

    public void setEnvironment(List<String> environment) {
        this.environment = environment;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setAddL1Repos(boolean flag) {
        this.addL1Repos = flag;
    }

    @Override
    public synchronized void destroy() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not running.");
        }
        this.process.destroy();
        this.running = false;
    }

    private synchronized void setJavaExecutableIfNecessary() throws IOException {
        if (this.javaExecutable == null) {
            if (this.javaHome == null) {
                this.javaHome = new File(System.getProperty("java.home"));
            }
            File javaBin = new File(this.javaHome, "bin");
            File javaPlain = new File(javaBin, "java");
            File javaExe = new File(javaBin, "java.exe");
            if (this.javaExecutable == null && javaPlain.exists() && javaPlain.isFile()) {
                this.javaExecutable = javaPlain;
            }
            if (this.javaExecutable == null && javaExe.exists() && javaExe.isFile()) {
                this.javaExecutable = javaExe;
            }
            if (this.javaExecutable == null) {
                throw new IOException("Can't find the Java binary; perhaps you need to set it yourself? Tried " + javaPlain.getAbsolutePath() + " and " + javaExe.getAbsolutePath());
            }
        }
    }

    public synchronized void start() throws IOException {
        if (this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is already running.");
        }
        HeartBeatService.startHeartBeatService();
        ArrayList<String> fullCommandList = new ArrayList<String>();
        ArrayList<String> allJavaArguments = new ArrayList<String>();
        File workingDir = this.directory != null ? this.directory : new File(System.getProperty("user.dir"));
        File generatedClasspathJar = this.generateClasspathJar(this.classpath != null ? this.classpath : System.getProperty("java.class.path"), workingDir);
        String l1Repos = System.getProperty("com.tc.l1.modules.repositories");
        if (l1Repos != null && this.addL1Repos) {
            allJavaArguments.add("-Dcom.tc.l1.modules.repositories=" + l1Repos);
        }
        allJavaArguments.add("-Dlinked-java-process-max-runtime=" + this.maxRuntime);
        allJavaArguments.addAll(this.javaArguments);
        this.setJavaExecutableIfNecessary();
        int socketPort = HeartBeatService.listenPort();
        Map<String, String> env = this.makeEnvMap(this.environment);
        LinkedJavaProcess.fixupEnvironment(env);
        fullCommandList.add(this.javaExecutable.getAbsolutePath());
        fullCommandList.add("-classpath");
        fullCommandList.add(generatedClasspathJar.getAbsolutePath());
        fullCommandList.addAll(allJavaArguments);
        fullCommandList.add(LinkedJavaProcessStarter.class.getName());
        fullCommandList.add(Integer.toString(socketPort));
        fullCommandList.add(this.mainClassName);
        fullCommandList.addAll(this.arguments);
        this.command = fullCommandList.toArray(new String[fullCommandList.size()]);
        System.err.println("Start java process with command: " + fullCommandList);
        this.process = Runtime.getRuntime().exec(this.command, this.makeEnv(env), workingDir);
        this.running = true;
    }

    private Map<String, String> makeEnvMap(List<String> list) {
        HashMap<String, String> rv = new HashMap<String, String>(System.getenv());
        for (String string : list) {
            String[] nameValue = string.split("=", 2);
            rv.put(nameValue[0], nameValue[1]);
        }
        return rv;
    }

    private String[] makeEnv(Map<String, String> env) {
        int i = 0;
        String[] rv = new String[env.size()];
        for (String key : env.keySet()) {
            rv[i] = key + "=" + env.get(key);
            ++i;
        }
        return rv;
    }

    private static void fixupEnvironment(Map<String, String> env) {
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            if (!env.containsKey("SYSTEMROOT")) {
                char i;
                String root = ":\\Windows";
                for (i = 'c'; i <= 'z'; i = (char)(i + '\u0001')) {
                    if (!new File(i + root).exists()) continue;
                    root = i + root;
                    break;
                }
                if (i > 'z') {
                    throw new RuntimeException("Can't find windir");
                }
                env.put("SYSTEMROOT", root);
            }
            String crappleDirs = "C:\\Program Files\\Rendezvous\\" + File.pathSeparator + "C:\\Program Files\\Bonjour\\";
            if (!env.containsKey("PATH")) {
                env.put("PATH", crappleDirs);
            } else {
                String path = env.get("PATH");
                path = path + File.pathSeparator + crappleDirs;
                env.put("PATH", path);
            }
        }
    }

    @Override
    public synchronized InputStream getInputStream() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.process.getInputStream();
    }

    public synchronized String[] getCommand() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.command;
    }

    public InputStream STDOUT() {
        return this.getInputStream();
    }

    public OutputStream STDIN() {
        return this.getOutputStream();
    }

    public InputStream STDERR() {
        return this.getErrorStream();
    }

    public void mergeSTDOUT() {
        this.mergeSTDOUT(null);
    }

    public void mergeSTDOUT(String identifier) {
        this.mergeStream(this.STDOUT(), System.out, identifier);
    }

    public void mergeSTDERR() {
        this.mergeSTDERR(null);
    }

    public void mergeSTDERR(String identifier) {
        this.mergeStream(this.STDERR(), System.err, identifier);
    }

    private void mergeStream(InputStream in, OutputStream out, String identifier) {
        StreamCopier copier = new StreamCopier(in, out, identifier);
        this.copiers.add(copier);
        copier.start();
    }

    @Override
    public synchronized InputStream getErrorStream() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.process.getErrorStream();
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.process.getOutputStream();
    }

    @Override
    public synchronized int exitValue() {
        if (this.process == null) {
            throw new IllegalStateException("This LinkedJavaProcess has not been started.");
        }
        int out = this.process.exitValue();
        this.running = false;
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() throws InterruptedException {
        Process theProcess = null;
        LinkedJavaProcess linkedJavaProcess = this;
        synchronized (linkedJavaProcess) {
            if (!this.running) {
                throw new IllegalStateException("This LinkedJavaProcess is not running.");
            }
            theProcess = this.process;
        }
        int exitCode = theProcess.waitFor();
        Iterator<StreamCopier> i = this.copiers.iterator();
        while (i.hasNext()) {
            Thread t = i.next();
            t.join();
            i.remove();
        }
        LinkedJavaProcess linkedJavaProcess2 = this;
        synchronized (linkedJavaProcess2) {
            this.running = false;
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateClasspathJar(String cp, File workingDir) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Class-Path", this.generateManifestClasspath(cp));
        File classpathJar = File.createTempFile("lcpclasspath", ".jar", workingDir);
        ZipOutputStream target = null;
        try {
            target = new JarOutputStream((OutputStream)new FileOutputStream(classpathJar), manifest);
        }
        finally {
            if (target != null) {
                try {
                    target.close();
                }
                catch (IOException e) {}
            }
        }
        return classpathJar;
    }

    private String generateManifestClasspath(String cp) throws IOException {
        String[] elements = cp.split(File.pathSeparator);
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if ((element = element.trim()).length() == 0) continue;
            File f = new File(element);
            if (f.exists()) {
                sb.append(f.toURI().toURL().toString()).append(" ");
                continue;
            }
            System.out.println("LCP: path element [" + element + "] doesn't exist, ignoring");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

