/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lcp;

import com.tc.lcp.HeartBeatService;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;

public class LinkedJavaProcessStarter {
    public static void main(String[] args) throws Exception {
        int pingPort = Integer.parseInt(args[0]);
        String childClass = args[1];
        String[] realArgs = new String[args.length - 2];
        if (realArgs.length > 0) {
            System.arraycopy(args, 2, realArgs, 0, realArgs.length);
        }
        HeartBeatService.registerForHeartBeat(pingPort, childClass);
        LinkedJavaProcessStarter.scheduleShutdownTimer();
        Class<?> mainClass = Class.forName(childClass);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{realArgs});
    }

    public static long getMaxRuntime() {
        return Long.parseLong(System.getProperty("linked-java-process-max-runtime", "0"));
    }

    public static void scheduleShutdownTimer() {
        long maxRuntimeInSeconds = LinkedJavaProcessStarter.getMaxRuntime();
        if (maxRuntimeInSeconds > 0L) {
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)new ShutdownTask(), maxRuntimeInSeconds * 1000L);
        }
    }

    static class ShutdownTask
    extends TimerTask {
        ShutdownTask() {
        }

        public void run() {
            System.err.println("Max runtime hit (" + LinkedJavaProcessStarter.getMaxRuntime() + "s). Force exit");
            System.err.flush();
            System.exit(255);
        }
    }
}

