/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HeartBeatServer {
    public static final String PULSE = "PULSE";
    public static final String KILL = "KILL";
    public static final String IS_APP_SERVER_ALIVE = "IS_APP_SERVER_ALIVE";
    public static final String IM_ALIVE = "IM_ALIVE";
    public static final int PULSE_INTERVAL = 30000;
    public static final int MISS_ALLOW = 5;
    private static DateFormat DATEFORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private ListenThread listenThread;
    private final List heartBeatThreads = new ArrayList();

    public static void log(String message) {
        System.out.println(DATEFORMAT.format(new Date()) + " - HeartBeatServer: " + message);
    }

    public void start() {
        if (this.listenThread == null) {
            this.listenThread = new ListenThread(this);
            this.listenThread.setDaemon(true);
            this.listenThread.start();
        }
    }

    public void shutdown() {
        try {
            this.listenThread.shutdown();
            this.listenThread.join();
            this.listenThread = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sendKillSignalToChildren();
    }

    public synchronized void sendKillSignalToChildren() {
        for (HeartBeatThread hb : this.heartBeatThreads) {
            hb.sendKillSignal();
        }
        this.heartBeatThreads.clear();
    }

    public synchronized boolean anyAppServerAlive() {
        boolean alive = false;
        for (HeartBeatThread hb : this.heartBeatThreads) {
            alive = alive || hb.pingAppServer();
        }
        return alive;
    }

    public synchronized void removeDeadClient(HeartBeatThread thread) {
        HeartBeatServer.log("Removed dead client: " + thread.getName());
        this.heartBeatThreads.remove(thread);
    }

    public synchronized void addThread(HeartBeatThread hb) {
        this.heartBeatThreads.add(hb);
    }

    public int listeningPort() {
        if (!this.listenThread.isAlive()) {
            throw new IllegalStateException("Heartbeat server has not started");
        }
        return this.listenThread.listeningPort();
    }

    public static void reallySleep(long millis) {
        try {
            long start;
            for (long millisLeft = millis; millisLeft > 0L; millisLeft -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                Thread.sleep(millisLeft);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class HeartBeatThread
    extends Thread {
        private Socket socket;
        private BufferedReader in;
        private PrintWriter out;
        private HeartBeatServer server;
        private boolean killed = false;
        private String clientName;
        private int missedPulseCount = 0;

        public HeartBeatThread(HeartBeatServer server, Socket s) {
            this.server = server;
            this.socket = s;
            try {
                this.socket.setSoTimeout(30000);
                this.socket.setTcpNoDelay(true);
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.out = new PrintWriter(this.socket.getOutputStream(), true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                this.clientName = this.in.readLine();
                this.setName(this.clientName);
                HeartBeatServer.log("got new client: " + this.clientName);
                while (true) lbl-1000:
                // 3 sources

                {
                    HeartBeatServer.reallySleep(30000L);
                    HeartBeatServer.log("send pulse to client: " + this.clientName);
                    this.out.println("PULSE");
                    try {
                        reply = this.in.readLine();
                        if (reply == null) {
                            throw new Exception("read-half of socket closed.");
                        }
                        this.missedPulseCount = 0;
                    }
                    catch (SocketTimeoutException toe) {
                        HeartBeatServer.log("Client: " + this.clientName + " missed " + ++this.missedPulseCount);
                        if (this.missedPulseCount >= 5) ** break;
                        continue;
                        throw new Exception("Client missed 5 pulses... considered it dead.");
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!this.killed) {
                    HeartBeatServer.log("Dead client detected: " + this.clientName + ". Exception message: " + e.getMessage());
                    this.server.removeDeadClient(this);
                }
                return;
            }
            ** GOTO lbl-1000
        }

        public void sendKillSignal() {
            try {
                this.killed = true;
                this.out.println(HeartBeatServer.KILL);
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean pingAppServer() {
            boolean alive = false;
            try {
                this.out.println(HeartBeatServer.IS_APP_SERVER_ALIVE);
                String reply = this.in.readLine();
                if (reply != null && HeartBeatServer.IM_ALIVE.equals(reply)) {
                    alive = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return alive;
        }
    }

    private static class ListenThread
    extends Thread {
        private ServerSocket serverSocket;
        private int listeningPort = -1;
        private boolean isShutdown = false;
        private HeartBeatServer server;

        public ListenThread(HeartBeatServer server) {
            this.server = server;
        }

        public void shutdown() {
            try {
                this.isShutdown = true;
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Socket clientSocket;
                ListenThread listenThread = this;
                synchronized (listenThread) {
                    this.isShutdown = false;
                    this.serverSocket = new ServerSocket(0);
                    this.listeningPort = this.serverSocket.getLocalPort();
                    this.notifyAll();
                }
                HeartBeatServer.log("Heartbeat server is online...");
                while ((clientSocket = this.serverSocket.accept()) != null) {
                    HeartBeatThread hb = new HeartBeatThread(this.server, clientSocket);
                    hb.setDaemon(true);
                    hb.start();
                    this.server.addThread(hb);
                }
            }
            catch (Exception e) {
                if (this.isShutdown) {
                    HeartBeatServer.log("Heartbeat server is shutdown");
                }
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int listeningPort() {
            ListenThread listenThread = this;
            synchronized (listenThread) {
                while (this.listeningPort == -1) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return this.listeningPort;
        }
    }
}

