/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lcp;

import com.tc.lcp.HeartBeatService;
import com.tc.lcp.LinkedJavaProcessStarter;
import com.tc.lcp.StreamCopier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LinkedJavaProcess {
    private File javaHome;
    private final String mainClassName;
    private String[] javaArguments;
    private final String[] arguments;
    private String[] environment;
    private File directory;
    private File javaExecutable;
    private Process process;
    private boolean running;
    private final List copiers = Collections.synchronizedList(new ArrayList());

    public LinkedJavaProcess(String mainClassName, String[] classArguments) {
        if (classArguments == null) {
            classArguments = new String[]{};
        }
        this.mainClassName = mainClassName;
        this.javaArguments = null;
        this.arguments = classArguments;
        this.environment = null;
        this.directory = null;
        this.javaExecutable = null;
        this.process = null;
        this.running = false;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public LinkedJavaProcess(String mainClassName) {
        this(mainClassName, null);
    }

    public void setJavaExecutable(File javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public void setJavaArguments(String[] javaArguments) {
        this.javaArguments = javaArguments;
    }

    public void setEnvironment(String[] environment) {
        this.environment = environment;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public synchronized void destroy() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not running.");
        }
        this.process.destroy();
        this.running = false;
    }

    private synchronized void setJavaExecutableIfNecessary() throws IOException {
        if (this.javaExecutable == null) {
            if (this.javaHome == null) {
                this.javaHome = new File(System.getProperty("java.home"));
            }
            File javaBin = new File(this.javaHome, "bin");
            File javaPlain = new File(javaBin, "java");
            File javaExe = new File(javaBin, "java.exe");
            if (this.javaExecutable == null && javaPlain.exists() && javaPlain.isFile()) {
                this.javaExecutable = javaPlain;
            }
            if (this.javaExecutable == null && javaExe.exists() && javaExe.isFile()) {
                this.javaExecutable = javaExe;
            }
            if (this.javaExecutable == null) {
                throw new IOException("Can't find the Java binary; perhaps you need to set it yourself? Tried " + javaPlain.getAbsolutePath() + " and " + javaExe.getAbsolutePath());
            }
        }
    }

    public synchronized void start() throws IOException {
        if (this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is already running.");
        }
        HeartBeatService.startHeartBeatService();
        LinkedList<String> fullCommandList = new LinkedList<String>();
        ArrayList<String> allJavaArguments = new ArrayList<String>();
        allJavaArguments.add("-Djava.class.path=" + System.getProperty("java.class.path"));
        allJavaArguments.add("-Dcom.tc.l1.modules.repositories=" + System.getProperty("com.tc.l1.modules.repositories"));
        if (this.javaArguments != null) {
            allJavaArguments.addAll(Arrays.asList(this.javaArguments));
        }
        this.setJavaExecutableIfNecessary();
        int socketPort = HeartBeatService.listenPort();
        Map env = this.makeEnvMap(Arrays.asList(this.environment == null ? new String[]{} : this.environment));
        LinkedJavaProcess.fixupEnvironment(env);
        fullCommandList.add(this.javaExecutable.getAbsolutePath());
        fullCommandList.addAll(allJavaArguments);
        fullCommandList.add(LinkedJavaProcessStarter.class.getName());
        fullCommandList.add(Integer.toString(socketPort));
        fullCommandList.add(this.mainClassName);
        if (this.arguments != null) {
            fullCommandList.addAll(Arrays.asList(this.arguments));
        }
        String[] fullCommand = fullCommandList.toArray(new String[fullCommandList.size()]);
        this.process = Runtime.getRuntime().exec(fullCommand, this.makeEnv(env), this.directory);
        this.running = true;
    }

    private Map makeEnvMap(List list) {
        HashMap<String, String> rv = new HashMap<String, String>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String[] nameValue = ((String)iter.next()).split("=", 2);
            rv.put(nameValue[0], nameValue[1]);
        }
        return rv;
    }

    private String[] makeEnv(Map env) {
        int i = 0;
        String[] rv = new String[env.size()];
        Iterator iter = env.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            rv[i] = key + "=" + env.get(key);
            ++i;
        }
        return rv;
    }

    private static void fixupEnvironment(Map env) {
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            if (!env.containsKey("SYSTEMROOT")) {
                String root = System.getenv("windir");
                if (root == null) {
                    throw new RuntimeException("cannot find %SYSTEMROOT% in the environment");
                }
                env.put("SYSTEMROOT", root);
            }
            String crappleDirs = "C:\\Program Files\\Rendezvous\\" + File.pathSeparator + "C:\\Program Files\\Bonjour\\";
            if (!env.containsKey("PATH")) {
                env.put("PATH", crappleDirs);
            } else {
                String path = (String)env.get("PATH");
                path = path + File.pathSeparator + crappleDirs;
                env.put("PATH", path);
            }
        }
    }

    public synchronized InputStream getInputStream() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.process.getInputStream();
    }

    public InputStream STDOUT() {
        return this.getInputStream();
    }

    public OutputStream STDIN() {
        return this.getOutputStream();
    }

    public InputStream STDERR() {
        return this.getErrorStream();
    }

    public void mergeSTDOUT() {
        this.mergeSTDOUT(null);
    }

    public void mergeSTDOUT(String identifier) {
        this.mergeStream(this.STDOUT(), System.out, identifier);
    }

    public void mergeSTDERR() {
        this.mergeSTDERR(null);
    }

    public void mergeSTDERR(String identifier) {
        this.mergeStream(this.STDERR(), System.err, identifier);
    }

    private void mergeStream(InputStream in, OutputStream out, String identifier) {
        StreamCopier copier = new StreamCopier(in, out, identifier);
        this.copiers.add(copier);
        copier.start();
    }

    public synchronized InputStream getErrorStream() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.process.getErrorStream();
    }

    public synchronized OutputStream getOutputStream() {
        if (!this.running) {
            throw new IllegalStateException("This LinkedJavaProcess is not yet running.");
        }
        return this.process.getOutputStream();
    }

    public synchronized int exitValue() {
        if (this.process == null) {
            throw new IllegalStateException("This LinkedJavaProcess has not been started.");
        }
        int out = this.process.exitValue();
        this.running = false;
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        Process theProcess = null;
        LinkedJavaProcess linkedJavaProcess = this;
        synchronized (linkedJavaProcess) {
            if (!this.running) {
                throw new IllegalStateException("This LinkedJavaProcess is not running.");
            }
            theProcess = this.process;
        }
        int exitCode = theProcess.waitFor();
        Iterator i = this.copiers.iterator();
        while (i.hasNext()) {
            Thread t = (Thread)i.next();
            t.join();
            i.remove();
        }
        LinkedJavaProcess linkedJavaProcess2 = this;
        synchronized (linkedJavaProcess2) {
            this.running = false;
        }
        return exitCode;
    }
}

