/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lcp;

import com.tc.lcp.HeartBeatClient;
import com.tc.lcp.HeartBeatServer;

public class HeartBeatService {
    private static HeartBeatServer server;

    public static synchronized void startHeartBeatService() {
        if (server == null) {
            server = new HeartBeatServer();
            server.start();
        }
    }

    public static synchronized void stopHeartBeatServer() {
        if (server != null) {
            server.shutdown();
            server = null;
        }
    }

    public static synchronized int listenPort() {
        HeartBeatService.ensureServerHasStarted();
        return server.listeningPort();
    }

    public static synchronized void registerForHeartBeat(int listenPort, String clientName) {
        HeartBeatService.registerForHeartBeat(listenPort, clientName, false);
    }

    public static synchronized void registerForHeartBeat(int listenPort, String clientName, boolean isAppServer) {
        HeartBeatService.ensureServerHasStarted();
        HeartBeatClient client = new HeartBeatClient(listenPort, clientName, isAppServer);
        client.setDaemon(true);
        client.start();
    }

    public static synchronized void sendKillSignalToChildren() {
        HeartBeatService.ensureServerHasStarted();
        server.sendKillSignalToChildren();
    }

    public static synchronized boolean anyAppServerAlive() {
        HeartBeatService.ensureServerHasStarted();
        return server.anyAppServerAlive();
    }

    private static void ensureServerHasStarted() {
        if (server == null) {
            new IllegalStateException("Heartbeat service has not started yet!");
        }
    }
}

