/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lcp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HeartBeatClient
extends Thread {
    private static final int HEARTBEAT_TIMEOUT = 60000;
    private static DateFormat DATEFORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private Socket socket;
    private boolean isAppServer = false;
    private String clientName;
    private int missedPulse = 0;

    public HeartBeatClient(int listenPort, String clientName, boolean isAppServer) {
        this.isAppServer = isAppServer;
        this.clientName = clientName;
        try {
            this.socket = new Socket("localhost", listenPort);
            this.socket.setSoTimeout(60000);
            this.socket.setTcpNoDelay(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void log(String message) {
        System.out.println(DATEFORMAT.format(new Date()) + " - HeartBeatClient: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
                out.println(this.clientName + ":" + this.socket.getLocalPort());
                while (true) {
                    try {
                        while (true) {
                            String signal;
                            if ((signal = in.readLine()) == null) {
                                throw new Exception("Null signal");
                            }
                            if ("PULSE".equals(signal)) {
                                HeartBeatClient.log("Received pulse from heartbeat server, port " + this.socket.getLocalPort());
                                out.println(signal);
                                this.missedPulse = 0;
                                continue;
                            }
                            if ("KILL".equals(signal)) {
                                HeartBeatClient.log("Received KILL from heartbeat server. Killing self.");
                                System.exit(1);
                                continue;
                            }
                            if (!"IS_APP_SERVER_ALIVE".equals(signal)) break;
                            HeartBeatClient.log("Received IS_APP_SERVER_ALIVE from heartbeat server. ");
                            if (this.isAppServer) {
                                out.println("IM_ALIVE");
                                HeartBeatClient.log("  responded: IM_ALIVE");
                                continue;
                            }
                            out.println("NOT_AN_APP_SERVER");
                            HeartBeatClient.log("  responded: NOT_AN_APP_SERVER");
                        }
                        throw new Exception("Unknown signal");
                    }
                    catch (SocketTimeoutException toe) {
                        HeartBeatClient.log("No pulse received for 60 seconds");
                        HeartBeatClient.log("Missed pulse count: " + this.missedPulse++);
                        if (this.missedPulse < 5) continue;
                        throw new Exception("Missing 5 pulses from HeartBeatServer");
                    }
                    break;
                }
            }
            catch (Throwable e) {
                HeartBeatClient.log("Caught exception in heartbeat client. Killing self.");
                e.printStackTrace();
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(100);
            }
        }
        catch (Throwable throwable) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            System.exit(100);
            throw throwable;
        }
    }
}

