/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service.monitor;

import org.terracotta.lease.service.monitor.Lease;

class ValidLease
implements Lease {
    private final long leaseExpiry;

    ValidLease(long leaseExpiry) {
        this.leaseExpiry = leaseExpiry;
    }

    @Override
    public boolean isExpired(long now) {
        return this.leaseExpiry - now < 0L;
    }

    @Override
    public boolean allowRenewal() {
        return true;
    }

    boolean expiresBefore(ValidLease newLease) {
        return this.leaseExpiry - newLease.leaseExpiry < 0L;
    }

    public String toString() {
        return "ValidLease{ leaseExpiry:" + this.leaseExpiry + " }";
    }
}

