/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service.monitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.entity.StateDumpable;
import org.terracotta.lease.TimeSource;
import org.terracotta.lease.service.closer.ClientConnectionCloser;
import org.terracotta.lease.service.monitor.ExpiredLease;
import org.terracotta.lease.service.monitor.Lease;
import org.terracotta.lease.service.monitor.ReconnectionLease;
import org.terracotta.lease.service.monitor.ValidLease;

public class LeaseState
implements StateDumpable {
    private static Logger LOGGER = LoggerFactory.getLogger(LeaseState.class);
    private final TimeSource timeSource;
    private final ClientConnectionCloser clientConnectionCloser;
    private final ConcurrentHashMap<ClientDescriptor, Lease> leases = new ConcurrentHashMap();

    public LeaseState(TimeSource timeSource, ClientConnectionCloser clientConnectionCloser) {
        this.timeSource = timeSource;
        this.clientConnectionCloser = clientConnectionCloser;
    }

    public void disconnected(ClientDescriptor clientDescriptor) {
        this.leases.remove(clientDescriptor);
    }

    public void reconnecting(ClientDescriptor clientDescriptor) {
        this.leases.put(clientDescriptor, new ReconnectionLease());
    }

    public void reconnected(ClientDescriptor clientDescriptor, long leaseLength) {
        Lease reconnectionLease = this.leases.get(clientDescriptor);
        if (!(reconnectionLease instanceof ReconnectionLease)) {
            throw new AssertionError((Object)"Got a reconnected event but the client does not have a ReconnectionLease");
        }
        ValidLease newLease = this.createLease(leaseLength);
        this.leases.put(clientDescriptor, newLease);
    }

    public boolean acquireLease(ClientDescriptor clientDescriptor, long leaseLength) {
        ValidLease newLease = this.createLease(leaseLength);
        while (true) {
            Lease currentLease;
            if ((currentLease = this.leases.get(clientDescriptor)) == null) {
                Lease existingLease = this.leases.putIfAbsent(clientDescriptor, newLease);
                if (existingLease != null) continue;
                return true;
            }
            if (!currentLease.allowRenewal()) {
                return false;
            }
            ValidLease currentValidLease = (ValidLease)currentLease;
            if (newLease.expiresBefore(currentValidLease)) {
                return true;
            }
            boolean replaced = this.leases.replace(clientDescriptor, currentLease, newLease);
            if (replaced) break;
        }
        return true;
    }

    private ValidLease createLease(long leaseLength) {
        long leaseExpiry = this.timeSource.nanoTime() + TimeUnit.MILLISECONDS.toNanos(leaseLength);
        return new ValidLease(leaseExpiry);
    }

    void checkLeases() {
        LOGGER.debug("Checking leases");
        long now = this.timeSource.nanoTime();
        for (ClientDescriptor clientDescriptor : this.leases.keySet()) {
            this.checkLease(clientDescriptor, now);
        }
    }

    private void checkLease(ClientDescriptor clientDescriptor, long now) {
        ExpiredLease expiredLease;
        Lease lease;
        boolean replaced;
        do {
            if ((lease = this.leases.get(clientDescriptor)) == null) {
                return;
            }
            if (lease instanceof ExpiredLease) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Lease for client: " + clientDescriptor + " is an ExpiredLease");
                }
                return;
            }
            if (lease.isExpired(now)) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Lease for client: " + clientDescriptor + " is still valid: " + lease);
            }
            return;
        } while (!(replaced = this.leases.replace(clientDescriptor, lease, expiredLease = new ExpiredLease())));
        LOGGER.info("Closing connection to client: " + clientDescriptor + " due to lease expiry");
        this.clientConnectionCloser.closeClientConnection(clientDescriptor);
    }

    public void addStateTo(StateDumpCollector stateDumpCollector) {
        for (Map.Entry<ClientDescriptor, Lease> entry : this.leases.entrySet()) {
            String leaseState = entry.getValue() instanceof ValidLease ? "valid" : "expired";
            stateDumpCollector.addState(entry.getKey().toString(), (Object)leaseState);
        }
    }
}

