/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service.config;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.config.service.ConfigValidator;
import org.terracotta.config.service.ServiceConfigParser;
import org.terracotta.lease.service.LeaseConstants;
import org.terracotta.lease.service.config.LeaseConfigValidator;
import org.terracotta.lease.service.config.LeaseConfiguration;
import org.terracotta.lease.service.config.LeaseElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LeaseConfigurationParser
implements ServiceConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaseConfigurationParser.class);
    private static final URL XML_SCHEMA = LeaseConfigurationParser.class.getResource("/lease-service.xsd");
    private static final String NAMESPACE_STRING = "http://www.terracotta.org/service/lease";
    private static final URI NAMESPACE_URI = URI.create("http://www.terracotta.org/service/lease");
    private static final String LEASE_LENGTH_ELEMENT_NAME = "lease-length";
    private static final String TIME_UNIT_ATTRIBUTE_NAME = "unit";
    private static final String MAX = "MAX";
    private static final List<TimeUnit> VALID_TIME_UNITS = Arrays.asList(TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS);
    private static final String VALID_TIME_UNITS_STRING = VALID_TIME_UNITS.stream().map(Object::toString).map(String::toLowerCase).collect(Collectors.joining(", "));

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE_URI;
    }

    public LeaseConfiguration parse(Element element, String source) {
        long maxLeaseLengthInMatchingUnits;
        TimeUnit timeUnit;
        LeaseElement leaseElement = this.parser().apply(element);
        String leaseLengthString = leaseElement.getLeaseValue();
        if (leaseLengthString.compareToIgnoreCase(MAX) == 0) {
            return new LeaseConfiguration(LeaseConstants.MAX_LEASE_LENGTH);
        }
        String timeUnitString = leaseElement.getTimeUnit();
        try {
            timeUnit = TimeUnit.valueOf(timeUnitString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown time unit: " + timeUnitString + ". Must be one of " + VALID_TIME_UNITS_STRING + ".", e);
        }
        if (!VALID_TIME_UNITS.contains((Object)timeUnit)) {
            throw new IllegalArgumentException("Invalid lease time unit: " + timeUnitString + ". Must be one of " + VALID_TIME_UNITS_STRING + ".");
        }
        long leaseLength = Long.parseLong(leaseLengthString);
        if (leaseLength > (maxLeaseLengthInMatchingUnits = timeUnit.convert(LeaseConstants.MAX_LEASE_LENGTH, TimeUnit.MILLISECONDS))) {
            throw new NumberFormatException("Lease length in " + timeUnitString + " must be less than or equal to: " + maxLeaseLengthInMatchingUnits);
        }
        return new LeaseConfiguration(TimeUnit.MILLISECONDS.convert(leaseLength, timeUnit));
    }

    public Function<Element, LeaseElement> parser() {
        return element -> {
            NodeList childElements = element.getElementsByTagNameNS(NAMESPACE_STRING, LEASE_LENGTH_ELEMENT_NAME);
            if (childElements.getLength() != 1) {
                LOGGER.error("Found " + childElements.getLength() + " lease-length elements. The XSD should have prevented this.");
                throw new AssertionError((Object)"The schema for connection-leasing element requires one and only one lease-length element");
            }
            Element leaseLengthElement = (Element)childElements.item(0);
            String leaseLengthString = leaseLengthElement.getTextContent();
            LOGGER.debug("Found lease length XML text: " + leaseLengthString);
            String timeUnitString = leaseLengthElement.getAttribute(TIME_UNIT_ATTRIBUTE_NAME);
            LOGGER.debug("Found lease length time unit: " + timeUnitString);
            return new LeaseElement(leaseLengthString, timeUnitString);
        };
    }

    public ConfigValidator getConfigValidator() {
        return new LeaseConfigValidator(this.parser());
    }
}

