/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.entity.StateDumpable;
import org.terracotta.lease.service.LeaseConstants;
import org.terracotta.lease.service.LeaseServiceProvider;

public class LeaseConfiguration
implements ServiceProviderConfiguration,
StateDumpable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaseConfiguration.class);
    private volatile long leaseLength;

    public LeaseConfiguration(long initialLength) {
        if (initialLength <= 0L) {
            throw new IllegalArgumentException("Only positive lease lengths are acceptable");
        }
        this.setLeaseLength(initialLength);
    }

    public long getLeaseLength() {
        return this.leaseLength;
    }

    public void setLeaseLength(long leaseLength) {
        if (leaseLength <= 0L) {
            LOGGER.warn("Non-positive lease length: " + leaseLength + ", ignoring it");
            this.leaseLength = LeaseConfiguration.use(LeaseConstants.DEFAULT_LEASE_LENGTH);
        }
        if (leaseLength > LeaseConstants.MAX_LEASE_LENGTH) {
            LOGGER.warn("Excessive lease length: " + leaseLength + ", using smaller value: " + LeaseConstants.MAX_LEASE_LENGTH);
            this.leaseLength = LeaseConfiguration.use(LeaseConstants.MAX_LEASE_LENGTH);
        }
        this.leaseLength = leaseLength;
    }

    public Class<? extends ServiceProvider> getServiceProviderType() {
        return LeaseServiceProvider.class;
    }

    public void addStateTo(StateDumpCollector stateDumpCollector) {
        stateDumpCollector.addState("leaseLength", (Object)this.leaseLength);
    }

    private static long use(long leaseLength) {
        LOGGER.info("Using lease length of " + leaseLength + " ms");
        return leaseLength;
    }
}

