/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service.config;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.terracotta.config.service.ConfigValidator;
import org.terracotta.config.service.ValidationException;
import org.terracotta.lease.service.config.LeaseElement;
import org.terracotta.lease.service.config.ValidationFailureId;
import org.w3c.dom.Element;

public class LeaseConfigValidator
implements ConfigValidator {
    private final Function<Element, LeaseElement> resourcesTypeSupplier;

    public LeaseConfigValidator(Function<Element, LeaseElement> resourcesTypeSupplier) {
        this.resourcesTypeSupplier = resourcesTypeSupplier;
    }

    public void validateAgainst(Element oneFragment, Element otherFragment) throws ValidationException {
        LeaseElement another;
        LeaseElement one = this.createObject(oneFragment);
        if (!this.compare(one, another = this.createObject(otherFragment))) {
            throw new ValidationException("Lease entries are not matching", ValidationFailureId.LEASE_ENTRY_MISMATCH.getFailureId());
        }
    }

    protected boolean compare(LeaseElement one, LeaseElement another) {
        TimeUnit oneTimeUnit = this.convert(one.getTimeUnit());
        TimeUnit anotherTimeUnit = this.convert(another.getTimeUnit());
        return TimeUnit.MILLISECONDS.convert(Long.parseLong(one.getLeaseValue()), oneTimeUnit) == TimeUnit.MILLISECONDS.convert(Long.parseLong(another.getLeaseValue()), anotherTimeUnit);
    }

    protected TimeUnit convert(String timeUnitString) {
        TimeUnit timeUnit = TimeUnit.valueOf(timeUnitString.toUpperCase());
        return timeUnit;
    }

    protected LeaseElement createObject(Element element) {
        return this.resourcesTypeSupplier.apply(element);
    }
}

