/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service;

import com.tc.classloader.BuiltinService;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.lease.TimeSource;
import org.terracotta.lease.TimeSourceProvider;
import org.terracotta.lease.service.LeaseConstants;
import org.terracotta.lease.service.LeaseService;
import org.terracotta.lease.service.LeaseServiceConfiguration;
import org.terracotta.lease.service.LeaseServiceImpl;
import org.terracotta.lease.service.closer.ClientConnectionCloser;
import org.terracotta.lease.service.closer.ProxyClientConnectionCloser;
import org.terracotta.lease.service.config.LeaseConfiguration;
import org.terracotta.lease.service.monitor.LeaseMonitorThread;
import org.terracotta.lease.service.monitor.LeaseState;

@BuiltinService
public class LeaseServiceProvider
implements ServiceProvider,
Closeable {
    private static Logger LOGGER = LoggerFactory.getLogger(LeaseServiceProvider.class);
    private LeaseConfiguration leaseConfiguration;
    private LeaseState leaseState;
    private LeaseMonitorThread leaseMonitorThread;
    private ProxyClientConnectionCloser proxyClientConnectionCloser;

    public boolean initialize(ServiceProviderConfiguration configuration, PlatformConfiguration platformConfiguration) {
        if (configuration instanceof LeaseConfiguration) {
            LOGGER.info("Initializing LeaseServiceProvider with " + configuration);
            this.leaseConfiguration = (LeaseConfiguration)configuration;
        } else {
            LOGGER.info("Initializing LeaseServiceProvider with default lease length of " + LeaseConstants.DEFAULT_LEASE_LENGTH + " ms");
            this.leaseConfiguration = new LeaseConfiguration(LeaseConstants.DEFAULT_LEASE_LENGTH);
        }
        TimeSource timeSource = TimeSourceProvider.getTimeSource();
        this.proxyClientConnectionCloser = new ProxyClientConnectionCloser();
        this.leaseState = new LeaseState(timeSource, this.proxyClientConnectionCloser);
        this.leaseMonitorThread = new LeaseMonitorThread(timeSource, this.leaseState);
        this.leaseMonitorThread.start();
        return true;
    }

    public <T> T getService(long consumerID, ServiceConfiguration<T> serviceConfiguration) {
        if (serviceConfiguration.getServiceType() == LeaseConfiguration.class) {
            return serviceConfiguration.getServiceType().cast(this.leaseConfiguration);
        }
        if (serviceConfiguration instanceof LeaseServiceConfiguration) {
            LOGGER.info("Creating LeaseService");
            LeaseServiceConfiguration leaseServiceConfiguration = (LeaseServiceConfiguration)serviceConfiguration;
            ClientConnectionCloser clientConnectionCloser = leaseServiceConfiguration.getClientConnectionCloser();
            LeaseService leaseService = this.createLeaseService(clientConnectionCloser);
            return serviceConfiguration.getServiceType().cast(leaseService);
        }
        throw new IllegalArgumentException("Unsupported service configuration: " + serviceConfiguration);
    }

    private LeaseService createLeaseService(ClientConnectionCloser clientConnectionCloser) {
        this.proxyClientConnectionCloser.setClientConnectionCloser(clientConnectionCloser);
        return new LeaseServiceImpl(this.leaseConfiguration, this.leaseState);
    }

    public Collection<Class<?>> getProvidedServiceTypes() {
        return Arrays.asList(LeaseService.class, LeaseConfiguration.class);
    }

    public void prepareForSynchronization() throws ServiceProviderCleanupException {
    }

    @Override
    public void close() {
        this.leaseMonitorThread.interrupt();
    }

    public void addStateTo(StateDumpCollector stateDumper) {
        stateDumper.addState("LeaseLength", (Object)Long.toString(this.leaseConfiguration.getLeaseLength()));
        this.leaseState.addStateTo(stateDumper.subStateDumpCollector("LeaseState"));
    }
}

