/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.lease.service.LeaseResult;
import org.terracotta.lease.service.LeaseService;
import org.terracotta.lease.service.config.LeaseConfiguration;
import org.terracotta.lease.service.monitor.LeaseState;

public class LeaseServiceImpl
implements LeaseService {
    private static Logger LOGGER = LoggerFactory.getLogger(LeaseServiceImpl.class);
    private final LeaseConfiguration leaseConfiguration;
    private final LeaseState leaseState;

    public LeaseServiceImpl(LeaseConfiguration leaseConfiguration, LeaseState leaseState) {
        this.leaseConfiguration = leaseConfiguration;
        this.leaseState = leaseState;
    }

    @Override
    public LeaseResult acquireLease(ClientDescriptor clientDescriptor) {
        LOGGER.debug("Client requested lease: " + clientDescriptor);
        long currentLeaseLength = this.getLeaseLength();
        boolean acquiredLease = this.leaseState.acquireLease(clientDescriptor, currentLeaseLength);
        if (acquiredLease) {
            LOGGER.debug("Client acquired lease: " + clientDescriptor);
            return LeaseResult.leaseGranted(currentLeaseLength);
        }
        LOGGER.debug("Client lease request rejected because connection is closing: " + clientDescriptor);
        return LeaseResult.leaseNotGranted();
    }

    @Override
    public void disconnected(ClientDescriptor clientDescriptor) {
        this.leaseState.disconnected(clientDescriptor);
    }

    @Override
    public void reconnecting(ClientDescriptor clientDescriptor) {
        this.leaseState.reconnecting(clientDescriptor);
    }

    @Override
    public void reconnected(ClientDescriptor clientDescriptor) {
        this.leaseState.reconnected(clientDescriptor, this.getLeaseLength());
    }

    protected long getLeaseLength() {
        return this.leaseConfiguration.getLeaseLength();
    }
}

