/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service;

import com.tc.classloader.CommonComponent;

@CommonComponent
public class LeaseResult {
    private static final long LEASE_NOT_GRANTED = -1L;
    private final long leaseLength;

    public static LeaseResult leaseNotGranted() {
        return new LeaseResult(-1L);
    }

    public static LeaseResult leaseGranted(long leaseLength) {
        if (leaseLength <= 0L) {
            throw new IllegalArgumentException("Illegal attempt to create a lease with a negative lease length");
        }
        return new LeaseResult(leaseLength);
    }

    private LeaseResult(long leaseLength) {
        this.leaseLength = leaseLength;
    }

    public boolean isLeaseGranted() {
        return this.leaseLength != -1L;
    }

    public long getLeaseLength() {
        if (this.leaseLength == -1L) {
            throw new IllegalStateException("Illegal attempt to get the length of a lease that was not granted");
        }
        return this.leaseLength;
    }
}

