/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service;

import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.service.TopologyService;
import org.terracotta.dynamic_config.server.api.ConfigChangeHandler;
import org.terracotta.dynamic_config.server.api.ConfigChangeHandlerManager;
import org.terracotta.dynamic_config.server.api.DynamicConfigExtension;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.lease.service.LeaseConfigChangeHandler;
import org.terracotta.lease.service.config.LeaseConfiguration;

public class LeaseDynamicConfigExtension
implements DynamicConfigExtension {
    public void configure(DynamicConfigExtension.Registrar registrar, PlatformConfiguration platformConfiguration) {
        TopologyService topologyService = (TopologyService)this.findService(platformConfiguration, TopologyService.class);
        ConfigChangeHandlerManager configChangeHandlerManager = (ConfigChangeHandlerManager)this.findService(platformConfiguration, ConfigChangeHandlerManager.class);
        NodeContext nodeContext = topologyService.getRuntimeNodeContext();
        LeaseConfiguration leaseConfiguration = new LeaseConfiguration(((Measure)nodeContext.getCluster().getClientLeaseDuration().orDefault()).getQuantity((Enum)TimeUnit.MILLISECONDS));
        configChangeHandlerManager.set(Setting.CLIENT_LEASE_DURATION, (ConfigChangeHandler)new LeaseConfigChangeHandler(leaseConfiguration));
        registrar.registerServiceProviderConfiguration((ServiceProviderConfiguration)leaseConfiguration);
    }
}

