/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.service;

import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.server.api.ConfigChangeHandler;
import org.terracotta.dynamic_config.server.api.InvalidConfigChangeException;
import org.terracotta.lease.service.config.LeaseConfiguration;

public class LeaseConfigChangeHandler
implements ConfigChangeHandler {
    private final LeaseConfiguration leaseConfiguration;

    public LeaseConfigChangeHandler(LeaseConfiguration leaseConfiguration) {
        this.leaseConfiguration = leaseConfiguration;
    }

    public void validate(NodeContext nodeContext, Configuration change) throws InvalidConfigChangeException {
        if (change.hasValue()) {
            try {
                Measure.parse((String)((String)change.getValue().get()), TimeUnit.class);
            }
            catch (Exception e) {
                throw new InvalidConfigChangeException(e.toString(), (Throwable)e);
            }
        }
    }

    public void apply(Configuration change) {
        Measure measure = change.getValue().isPresent() ? Measure.parse((String)((String)change.getValue().get()), TimeUnit.class) : (Measure)Setting.CLIENT_LEASE_DURATION.getDefaultValue();
        long quantity = measure.to((Enum)TimeUnit.MILLISECONDS).getQuantity();
        this.leaseConfiguration.setLeaseLength(quantity);
    }
}

