/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import com.tc.classloader.PermanentEntity;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.SyncMessageCodec;
import org.terracotta.lease.ActiveLeaseAcquirer;
import org.terracotta.lease.LeaseAcquirerCodec;
import org.terracotta.lease.LeaseMessage;
import org.terracotta.lease.LeaseMessageType;
import org.terracotta.lease.LeaseResponse;
import org.terracotta.lease.PassiveLeaseAcquirer;
import org.terracotta.lease.service.LeaseService;
import org.terracotta.lease.service.LeaseServiceConfiguration;
import org.terracotta.lease.service.closer.ClientConnectionCloserImpl;

@PermanentEntity(type="org.terracotta.lease.LeaseAcquirer", name="SystemLeaseAcquirer", version=1)
public class LeaseAcquirerServerService
implements EntityServerService<LeaseMessage, LeaseResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaseAcquirerServerService.class);

    public long getVersion() {
        return 1L;
    }

    public boolean handlesEntityType(String typeName) {
        return "org.terracotta.lease.LeaseAcquirer".equals(typeName);
    }

    public ActiveServerEntity<LeaseMessage, LeaseResponse> createActiveEntity(ServiceRegistry serviceRegistry, byte[] bytes) throws ConfigurationException {
        ClientCommunicator clientCommunicator = (ClientCommunicator)this.getService(serviceRegistry, (ServiceConfiguration)new BasicServiceConfiguration(ClientCommunicator.class));
        ClientConnectionCloserImpl clientConnectionCloser = new ClientConnectionCloserImpl(clientCommunicator);
        LeaseServiceConfiguration leaseServiceConfiguration = new LeaseServiceConfiguration(clientConnectionCloser);
        LeaseService leaseService = this.getService(serviceRegistry, leaseServiceConfiguration);
        IEntityMessenger entityMessenger = (IEntityMessenger)this.getService(serviceRegistry, (ServiceConfiguration)new BasicServiceConfiguration(IEntityMessenger.class));
        return new ActiveLeaseAcquirer(leaseService, clientCommunicator, (IEntityMessenger<LeaseMessage, LeaseResponse>)entityMessenger);
    }

    protected <T> T getService(ServiceRegistry serviceRegistry, ServiceConfiguration<T> serviceConfiguration) throws ConfigurationException {
        try {
            Object service = serviceRegistry.getService(serviceConfiguration);
            if (service == null) {
                LOGGER.error("Missing service: " + serviceConfiguration.getServiceType());
                throw new ConfigurationException("Missing service: " + serviceConfiguration.getServiceType());
            }
            return (T)service;
        }
        catch (ServiceException e) {
            LOGGER.error("Too many services of type: " + serviceConfiguration.getServiceType() + ", expected 1");
            throw new ConfigurationException("Too many services of type: " + serviceConfiguration.getServiceType() + ", expected 1", (Throwable)e);
        }
    }

    public PassiveServerEntity<LeaseMessage, LeaseResponse> createPassiveEntity(ServiceRegistry serviceRegistry, byte[] bytes) throws ConfigurationException {
        return new PassiveLeaseAcquirer();
    }

    public ConcurrencyStrategy<LeaseMessage> getConcurrencyStrategy(byte[] bytes) {
        return new ConcurrencyStrategy<LeaseMessage>(){

            public int concurrencyKey(LeaseMessage leaseMessage) {
                LeaseMessageType messageType = leaseMessage.getType();
                switch (messageType) {
                    case LEASE_REQUEST: {
                        return Integer.MIN_VALUE;
                    }
                    case LEASE_RECONNECT_FINISHED: {
                        return 0;
                    }
                }
                throw new AssertionError((Object)("Unknown LeaseMessage type: " + messageType));
            }

            public Set<Integer> getKeysForSynchronization() {
                return Collections.emptySet();
            }
        };
    }

    public MessageCodec<LeaseMessage, LeaseResponse> getMessageCodec() {
        return new LeaseAcquirerCodec();
    }

    public SyncMessageCodec<LeaseMessage> getSyncMessageCodec() {
        return null;
    }
}

