/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.entity.ActiveInvokeContext;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.lease.IgnoredLeaseResponse;
import org.terracotta.lease.LeaseAcquirerAvailable;
import org.terracotta.lease.LeaseMessage;
import org.terracotta.lease.LeaseMessageType;
import org.terracotta.lease.LeaseReconnectData;
import org.terracotta.lease.LeaseReconnectFinished;
import org.terracotta.lease.LeaseRequest;
import org.terracotta.lease.LeaseRequestResult;
import org.terracotta.lease.LeaseResponse;
import org.terracotta.lease.service.LeaseResult;
import org.terracotta.lease.service.LeaseService;

public class ActiveLeaseAcquirer
implements ActiveServerEntity<LeaseMessage, LeaseResponse> {
    private final LeaseService leaseService;
    private final ClientCommunicator clientCommunicator;
    private final IEntityMessenger<LeaseMessage, LeaseResponse> entityMessenger;
    private final ConcurrentHashMap<ClientDescriptor, Long> connectionSequenceNumbers = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, ClientDescriptor> clientDescriptors = new ConcurrentHashMap();

    public ActiveLeaseAcquirer(LeaseService leaseService, ClientCommunicator clientCommunicator, IEntityMessenger<LeaseMessage, LeaseResponse> entityMessenger) {
        this.leaseService = leaseService;
        this.clientCommunicator = clientCommunicator;
        this.entityMessenger = entityMessenger;
    }

    public void connected(ClientDescriptor clientDescriptor) {
    }

    public void disconnected(ClientDescriptor clientDescriptor) {
        this.leaseService.disconnected(clientDescriptor);
        this.connectionSequenceNumbers.remove(clientDescriptor);
    }

    public LeaseResponse invokeActive(ActiveInvokeContext<LeaseResponse> context, LeaseMessage leaseMessage) {
        LeaseMessageType messageType = leaseMessage.getType();
        switch (messageType) {
            case LEASE_REQUEST: {
                return this.handleLeaseRequest(context, (LeaseRequest)leaseMessage);
            }
            case LEASE_RECONNECT_FINISHED: {
                return this.handleReconnectFinished((LeaseReconnectFinished)leaseMessage);
            }
        }
        throw new AssertionError((Object)("Unexpected type of LeaseMessage: " + messageType));
    }

    private LeaseResponse handleLeaseRequest(ActiveInvokeContext<LeaseResponse> context, LeaseRequest leaseRequest) {
        ClientDescriptor clientDescriptor = context.getClientDescriptor();
        if (!this.isLatestConnection(clientDescriptor, leaseRequest)) {
            return LeaseRequestResult.oldConnection();
        }
        LeaseResult leaseResult = this.leaseService.acquireLease(clientDescriptor);
        if (leaseResult.isLeaseGranted()) {
            long leaseLength = leaseResult.getLeaseLength();
            return LeaseRequestResult.leaseGranted((long)leaseLength);
        }
        return LeaseRequestResult.leaseNotGranted();
    }

    private boolean isLatestConnection(ClientDescriptor clientDescriptor, LeaseRequest leaseRequest) {
        Long latestConnectionSequenceNumber = this.connectionSequenceNumbers.get(clientDescriptor);
        if (latestConnectionSequenceNumber == null) {
            return true;
        }
        long messageConnectionSequenceNumber = leaseRequest.getConnectionSequenceNumber();
        if (messageConnectionSequenceNumber > latestConnectionSequenceNumber) {
            throw new AssertionError((Object)("Connection sequence numbers should not jump ahead, expected: " + latestConnectionSequenceNumber + " actual: " + messageConnectionSequenceNumber));
        }
        return messageConnectionSequenceNumber == latestConnectionSequenceNumber;
    }

    public ActiveServerEntity.ReconnectHandler startReconnect() {
        return (clientDescriptor, bytes) -> {
            LeaseReconnectData reconnectData = LeaseReconnectData.decode((byte[])bytes);
            long connectionSequenceNumber = reconnectData.getConnectionSequenceNumber();
            this.connectionSequenceNumbers.put(clientDescriptor, connectionSequenceNumber);
            this.leaseService.reconnecting(clientDescriptor);
            UUID uuid = UUID.randomUUID();
            this.clientDescriptors.put(uuid, clientDescriptor);
            try {
                this.entityMessenger.messageSelf((EntityMessage)new LeaseReconnectFinished(uuid));
            }
            catch (MessageCodecException e) {
                throw new RuntimeException("Failed to encode self message to indicate reconnect completion", e);
            }
        };
    }

    private LeaseResponse handleReconnectFinished(LeaseReconnectFinished reconnectFinished) {
        UUID uuid = reconnectFinished.getUUID();
        ClientDescriptor clientDescriptor = this.clientDescriptors.remove(uuid);
        this.leaseService.reconnected(clientDescriptor);
        try {
            this.clientCommunicator.sendNoResponse(clientDescriptor, (EntityResponse)new LeaseAcquirerAvailable());
        }
        catch (MessageCodecException e) {
            throw new RuntimeException("Failed to encode message to client to inform that reconnect has completed", e);
        }
        return new IgnoredLeaseResponse();
    }

    public void loadExisting() {
    }

    public void createNew() throws ConfigurationException {
    }

    public void synchronizeKeyToPassive(PassiveSynchronizationChannel<LeaseMessage> passiveSynchronizationChannel, int concurrencyKey) {
    }

    public void destroy() {
    }
}

