/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.nio.ByteBuffer;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.lease.IgnoredLeaseResponse;
import org.terracotta.lease.LeaseAcquirerAvailable;
import org.terracotta.lease.LeaseMessage;
import org.terracotta.lease.LeaseMessageType;
import org.terracotta.lease.LeaseReconnectFinished;
import org.terracotta.lease.LeaseRequest;
import org.terracotta.lease.LeaseRequestResult;
import org.terracotta.lease.LeaseResponse;
import org.terracotta.lease.LeaseResponseType;
import org.terracotta.runnel.EnumMapping;
import org.terracotta.runnel.EnumMappingBuilder;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class LeaseAcquirerCodec
implements MessageCodec<LeaseMessage, LeaseResponse> {
    private static Struct messageStruct = LeaseAcquirerCodec.createMessageStruct();
    private static Struct responseStruct = LeaseAcquirerCodec.createResponseStruct();

    public byte[] encodeMessage(LeaseMessage leaseMessage) throws MessageCodecException {
        StructEncoder<Void> encoder = messageStruct.encoder();
        encoder.enm("messageType", (Object)leaseMessage.getType());
        leaseMessage.encode(encoder);
        return encoder.encode().array();
    }

    public LeaseMessage decodeMessage(byte[] bytes) throws MessageCodecException {
        StructDecoder<Void> decoder = messageStruct.decoder(ByteBuffer.wrap(bytes));
        LeaseMessageType type = (LeaseMessageType)((Object)decoder.enm("messageType").get());
        return type.decode(decoder);
    }

    public byte[] encodeResponse(LeaseResponse leaseResponse) throws MessageCodecException {
        StructEncoder<Void> encoder = responseStruct.encoder();
        encoder.enm("responseType", (Object)leaseResponse.getType());
        leaseResponse.encode(encoder);
        return encoder.encode().array();
    }

    public LeaseResponse decodeResponse(byte[] bytes) throws MessageCodecException {
        StructDecoder<Void> decoder = responseStruct.decoder(ByteBuffer.wrap(bytes));
        LeaseResponseType type = (LeaseResponseType)((Object)decoder.enm("responseType").get());
        return type.decode(decoder);
    }

    private static Struct createMessageStruct() {
        StructBuilder builder = StructBuilder.newStructBuilder();
        builder.enm("messageType", 10, LeaseAcquirerCodec.createMessageTypeMapping());
        LeaseRequest.addStruct(builder, 20);
        LeaseReconnectFinished.addStruct(builder, 30);
        return builder.build();
    }

    private static Struct createResponseStruct() {
        StructBuilder builder = StructBuilder.newStructBuilder();
        builder.enm("responseType", 10, LeaseAcquirerCodec.createResponseTypeMapping());
        LeaseRequestResult.addStruct(builder, 20);
        LeaseAcquirerAvailable.addStruct(builder, 30);
        IgnoredLeaseResponse.addStruct(builder, 40);
        return builder.build();
    }

    private static Struct createReconnectStruct() {
        StructBuilder builder = StructBuilder.newStructBuilder();
        builder.int64("connectionSequenceNumber", 10);
        return builder.build();
    }

    private static EnumMapping createMessageTypeMapping() {
        EnumMappingBuilder<LeaseMessageType> mapping = EnumMappingBuilder.newEnumMappingBuilder(LeaseMessageType.class);
        mapping.mapping(LeaseMessageType.LEASE_REQUEST, 1);
        mapping.mapping(LeaseMessageType.LEASE_RECONNECT_FINISHED, 2);
        return mapping.build();
    }

    private static EnumMapping createResponseTypeMapping() {
        EnumMappingBuilder<LeaseResponseType> mapping = EnumMappingBuilder.newEnumMappingBuilder(LeaseResponseType.class);
        mapping.mapping(LeaseResponseType.LEASE_REQUEST_RESULT, 1);
        mapping.mapping(LeaseResponseType.LEASE_ACQUIRER_AVAILABLE, 2);
        mapping.mapping(LeaseResponseType.IGNORED_LEASE_RESPONSE, 3);
        return mapping.build();
    }
}

