/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.lease.CleaningLeaseMaintainer;
import org.terracotta.lease.LeaseAcquirer;
import org.terracotta.lease.LeaseExpiryConnectionKillingThread;
import org.terracotta.lease.LeaseMaintainer;
import org.terracotta.lease.LeaseMaintainerImpl;
import org.terracotta.lease.LeaseMaintenanceThread;
import org.terracotta.lease.LeaseReconnectListener;
import org.terracotta.lease.ProxyLeaseReconnectListener;

public class LeaseMaintainerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaseMaintainerFactory.class);

    public static LeaseMaintainer createLeaseMaintainer(Connection connection) {
        LOGGER.info("Creating LeaseMaintainer for connection: " + connection);
        ProxyLeaseReconnectListener leaseReconnectListener = new ProxyLeaseReconnectListener();
        LeaseAcquirer leaseAcquirer = LeaseMaintainerFactory.getLeaseAcquirer(connection, leaseReconnectListener);
        LeaseMaintainerImpl leaseMaintainer = new LeaseMaintainerImpl(leaseAcquirer);
        leaseReconnectListener.setUnderlying(leaseMaintainer);
        LeaseMaintenanceThread leaseMaintenanceThread = new LeaseMaintenanceThread(leaseMaintainer);
        LeaseExpiryConnectionKillingThread leaseExpiryConnectionKillingThread = new LeaseExpiryConnectionKillingThread(leaseMaintainer, connection);
        leaseMaintenanceThread.start();
        leaseExpiryConnectionKillingThread.start();
        return new CleaningLeaseMaintainer((LeaseMaintainer)leaseMaintainer, connection, leaseMaintenanceThread, leaseExpiryConnectionKillingThread);
    }

    private static LeaseAcquirer getLeaseAcquirer(Connection connection, LeaseReconnectListener leaseReconnectListener) {
        try {
            EntityRef entityRef = connection.getEntityRef(LeaseAcquirer.class, 1L, "SystemLeaseAcquirer");
            return (LeaseAcquirer)entityRef.fetchEntity((Object)leaseReconnectListener);
        }
        catch (EntityNotProvidedException e) {
            throw new IllegalStateException("LeaseAcquirer entity is not installed", e);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("LeaseAcquirer entity is not installed with the name SystemLeaseAcquirer", e);
        }
        catch (EntityVersionMismatchException e) {
            throw new IllegalStateException("LeaseAcquirer entity is not version 1 for the name SystemLeaseAcquirer", e);
        }
    }
}

