/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import com.tc.util.ManagedServiceLoader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import org.terracotta.connection.ConnectionException;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionService;

public class LeasedConnectionFactory {
    private static final String DEFAULT_CONNECTION_TYPE = "terracotta";

    public static LeasedConnection connect(URI uri, Properties properties) throws ConnectionException {
        return LeasedConnectionFactory.getLeasedConnection(uri, properties);
    }

    public static LeasedConnection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        return LeasedConnectionFactory.getLeasedConnection(servers, properties);
    }

    private static LeasedConnection getLeasedConnection(URI uri, Properties properties) throws ConnectionException {
        LeasedConnectionService leasedConnectionService = LeasedConnectionFactory.getServices().stream().filter(connectionService -> connectionService.handlesURI(uri)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown URI " + uri));
        return leasedConnectionService.connect(uri, properties);
    }

    private static LeasedConnection getLeasedConnection(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        String connectionType = properties.getProperty("connection.type", DEFAULT_CONNECTION_TYPE);
        LeasedConnectionService leasedConnectionService = LeasedConnectionFactory.getServices().stream().filter(connectionService -> connectionService.handlesConnectionType(connectionType)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown connection type " + connectionType));
        return leasedConnectionService.connect(servers, properties);
    }

    private static Collection<LeasedConnectionService> getServices() {
        return ManagedServiceLoader.loadServices(LeasedConnectionService.class, (ClassLoader)LeasedConnectionService.class.getClassLoader());
    }
}

