/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.lease.LeaseMaintainer;
import org.terracotta.lease.LeaseMaintainerFactory;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.TimeBudget;

public class BasicLeasedConnection
implements LeasedConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicLeasedConnection.class);
    private final Connection base;
    private final LeaseMaintainer leaseMaintainer;

    public static BasicLeasedConnection create(Connection connection, TimeBudget timeBudget) throws ConnectionException {
        LeaseMaintainer leaseMaintainer = LeaseMaintainerFactory.createLeaseMaintainer(connection);
        Exception exception = null;
        try {
            boolean leased = leaseMaintainer.waitForLease(timeBudget.remaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            if (!leased) {
                exception = new IOException("Unable to acquire lease for connection before connection timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            exception = e;
        }
        if (exception != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close connection that we failed to get a lease on", (Throwable)e);
            }
            throw new ConnectionException((Throwable)exception);
        }
        return new BasicLeasedConnection(connection, leaseMaintainer);
    }

    private BasicLeasedConnection(Connection base, LeaseMaintainer leaseMaintainer) {
        this.base = base;
        this.leaseMaintainer = leaseMaintainer;
    }

    public <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
        return this.base.getEntityRef(cls, version, name);
    }

    public void close() throws IOException {
        this.leaseMaintainer.destroy();
    }
}

