/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ui.util;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.terracotta.dso.TcPlugin;
import org.terracotta.ui.util.FolderSelectionDialog;

public final class SWTUtil {
    private SWTUtil() {
    }

    public static void makeIntField(Text text) {
        text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                if (e.widget.getDisplay() == null) {
                    e.widget.removeListener(25, (Listener)this);
                    return;
                }
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
    }

    public static void setBGColorRecurse(Color color, Control control) {
        control.setBackground(color);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            for (int i = 0; i < children.length; ++i) {
                SWTUtil.setBGColorRecurse(color, children[i]);
            }
        }
    }

    public static Control getAncestorOfClass(Class clazz, Control comp) {
        if (comp.getClass().equals(clazz)) {
            return comp;
        }
        while ((comp = comp.getParent()) != null) {
            if (!clazz.isAssignableFrom(comp.getClass())) continue;
            return comp;
        }
        return null;
    }

    public static int textColumnsToPixels(Control control, int columns) {
        GC gc = new GC((Drawable)control);
        FontMetrics fm = gc.getFontMetrics();
        int width = columns * fm.getAverageCharWidth();
        int height = fm.getHeight();
        gc.dispose();
        return control.computeSize((int)width, (int)height).x;
    }

    public static int textRowsToPixels(Control control, int rows) {
        GC gc = new GC((Drawable)control);
        FontMetrics fm = gc.getFontMetrics();
        int height = rows * fm.getHeight();
        gc.dispose();
        return control.computeSize((int)0, (int)height).y;
    }

    public static int tableRowsToPixels(Table table, int rows) {
        return table.getHeaderHeight() + rows * table.getItemHeight();
    }

    public static void applyDefaultButtonSize(Button button) {
        Point preferredSize = button.computeSize(-1, -1, false);
        Point hint = Geometry.max((Point)LayoutConstants.getMinButtonSize(), (Point)preferredSize);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(hint).applyTo((Control)button);
    }

    public static void placeDialogInCenter(Shell parent, Shell shell) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static void makeTableColumnsResizeEqualWidth(Composite tablePanel, Table table) {
        Table control = table;
        control.addControlListener((ControlListener)new ControlAdapter((Control)control, table){
            final /* synthetic */ Control val$control;
            final /* synthetic */ Table val$table;
            {
                this.val$control = control;
                this.val$table = table;
            }

            public void controlResized(ControlEvent e) {
                if (e.widget.getDisplay() == null) {
                    ((Control)e.widget).removeControlListener((ControlListener)this);
                    return;
                }
                Rectangle area = this.val$control.getBounds();
                int widthHint = -1;
                int heightHint = -1;
                Point preferredSize = this.val$table.computeSize(widthHint, heightHint);
                int width = area.width - 2 * this.val$table.getBorderWidth();
                if (preferredSize.y > area.height + this.val$table.getHeaderHeight()) {
                    Point vBarSize = this.val$table.getVerticalBar().getSize();
                    width -= vBarSize.x + 1;
                }
                TableColumn[] columns = this.val$table.getColumns();
                int colWidth = width / columns.length;
                for (int i = 0; i < columns.length; ++i) {
                    columns[i].setWidth(colWidth);
                }
            }
        });
    }

    public static TableWeightedResizeHandler makeTableColumnsResizeWeightedWidth(Composite tablePanel, Table table, int[] columnWeights) {
        TableWeightedResizeHandler result = new TableWeightedResizeHandler(tablePanel, table, columnWeights);
        table.addControlListener((ControlListener)result);
        return result;
    }

    public static void makeTableColumnsEditable(final Table table, final int[] indices) {
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget.getDisplay() == null) {
                    event.widget.removeListener(3, (Listener)this);
                    return;
                }
                Rectangle clientArea = table.getClientArea();
                Point pt = new Point(event.x, event.y);
                for (int index = table.getTopIndex(); index < table.getItemCount(); ++index) {
                    boolean visible = false;
                    final TableItem item = table.getItem(index);
                    for (int i = 0; i < indices.length; ++i) {
                        Rectangle rect = item.getBounds(indices[i]);
                        if (rect.contains(pt)) {
                            final int column = indices[i];
                            final Text text = new Text((Composite)table, 0);
                            final String initialValue = item.getText(indices[i]);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    Event updateEvent = new Event();
                                    block0 : switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            if (!initialValue.equals(text.getText())) {
                                                updateEvent.item = item;
                                                updateEvent.index = column;
                                                table.notifyListeners(36, updateEvent);
                                            }
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    if (!initialValue.equals(text.getText())) {
                                                        updateEvent.item = item;
                                                        updateEvent.index = column;
                                                        table.notifyListeners(36, updateEvent);
                                                    }
                                                    text.dispose();
                                                    e.doit = false;
                                                    break block0;
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            editor.setEditor((Control)text, item, indices[i]);
                            text.setText(initialValue);
                            text.setFocus();
                            return;
                        }
                        if (visible || !rect.intersects(clientArea)) continue;
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
    }

    public static void makeTableComboItem(final Table table, final int column, final String[] values) {
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget.getDisplay() == null) {
                    event.widget.removeListener(3, (Listener)this);
                    return;
                }
                Rectangle clientArea = table.getClientArea();
                Point pt = new Point(event.x, event.y);
                for (int index = table.getTopIndex(); index < table.getItemCount(); ++index) {
                    boolean visible = false;
                    final TableItem item = table.getItem(index);
                    Rectangle rect = item.getBounds(column);
                    if (rect.contains(pt)) {
                        final CCombo combo = new CCombo((Composite)table, 8);
                        for (int i = 0; i < values.length; ++i) {
                            combo.add(values[i]);
                        }
                        final String initialValue = item.getText(column);
                        final boolean[] isMouseOverCombo = new boolean[]{false};
                        Listener comboListener = new Listener(){

                            public void handleEvent(Event e) {
                                Event updateEvent = new Event();
                                block0 : switch (e.type) {
                                    case 16: {
                                        if (isMouseOverCombo[0]) {
                                            return;
                                        }
                                        if (combo.getSelectionIndex() != -1 && !initialValue.equals(combo.getText())) {
                                            item.setText(column, combo.getText());
                                            updateEvent.item = item;
                                            updateEvent.index = column;
                                            table.notifyListeners(36, updateEvent);
                                        }
                                        combo.dispose();
                                        break;
                                    }
                                    case 31: {
                                        switch (e.detail) {
                                            case 4: {
                                                if (combo.getSelectionIndex() != -1 && !initialValue.equals(combo.getText())) {
                                                    item.setText(column, combo.getText());
                                                    updateEvent.item = item;
                                                    updateEvent.index = column;
                                                    table.notifyListeners(36, updateEvent);
                                                }
                                                combo.dispose();
                                                e.doit = false;
                                                break block0;
                                            }
                                            case 2: {
                                                combo.dispose();
                                                e.doit = false;
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        combo.addListener(16, comboListener);
                        combo.addListener(31, comboListener);
                        combo.addListener(6, new Listener(){

                            public void handleEvent(Event e) {
                                isMouseOverCombo[0] = true;
                            }
                        });
                        combo.addListener(7, new Listener(){

                            public void handleEvent(Event e) {
                                isMouseOverCombo[0] = false;
                            }
                        });
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Event updateEvent = new Event();
                                item.setText(column, combo.getText());
                                updateEvent.item = item;
                                updateEvent.index = column;
                                table.notifyListeners(36, updateEvent);
                                combo.dispose();
                            }
                        });
                        editor.setEditor((Control)combo, item, column);
                        combo.select(combo.indexOf(item.getText(column)));
                        combo.setFocus();
                        return;
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
    }

    public static IFolder openSelectFolderDialog(final IProject project, String title, String message) {
        FolderSelectionDialog dialog = new FolderSelectionDialog(TcPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new FolderSelectionContentProvider());
        dialog.setInput(project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals(project);
                }
                return element instanceof IFolder;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                String id = TcPlugin.getPluginId();
                if (selection == null || selection.length != 1 || !(selection[0] instanceof IFolder)) {
                    return new Status(4, id, 4, "", null);
                }
                return new Status(0, id, 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private static class FolderSelectionContentProvider
    extends WorkbenchContentProvider {
        private FolderSelectionContentProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof IFolder)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TableWeightedResizeHandler
    extends ControlAdapter {
        Composite tablePanel;
        Table table;
        int[] columnWeights;
        int totalWeight;

        public TableWeightedResizeHandler(Composite tablePanel, Table table, int[] columnWeights) {
            this.tablePanel = tablePanel;
            this.table = table;
            this.setColumnWeights(columnWeights);
        }

        public void setColumnWeights(int[] columnWeights) {
            this.columnWeights = columnWeights;
            for (int i = 0; i < columnWeights.length; ++i) {
                this.totalWeight += columnWeights[i];
            }
        }

        public void controlResized(ControlEvent e) {
            if (this.table.isDisposed() || this.table.getDisplay() == null) {
                ((Control)e.widget).removeControlListener((ControlListener)this);
                return;
            }
            Rectangle area = this.tablePanel.getClientArea();
            Point preferredSize = this.table.computeSize(-1, -1);
            int width = area.width - 2 * this.table.getBorderWidth();
            if (preferredSize.y + this.table.getHeaderHeight() > area.height) {
                Point vBarSize = this.table.getVerticalBar().getSize();
                width -= vBarSize.x + 1;
            }
            TableColumn[] columns = this.table.getColumns();
            int widthUnit = width / this.totalWeight;
            for (int i = 0; i < columns.length; ++i) {
                columns[i].setWidth(widthUnit * this.columnWeights[i]);
            }
        }

        public void dispose() {
            this.table.removeControlListener((ControlListener)this);
            this.table = null;
            this.tablePanel = null;
        }
    }
}

