/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.wizards;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.editors.chooser.ConfigFileBehavior;
import org.terracotta.dso.editors.chooser.PackageNavigator;
import org.terracotta.ui.util.SWTUtil;

public class SetupWizardPage
extends WizardPage {
    private IProject m_project;
    private Text m_configPathField;
    private Button m_configFileButton;
    private Text m_serverOptionsField;
    private Button m_resetOptionsButton;
    private static final String TERRACOTTA_CONFIG = "Terracotta Configuration";
    private static final String BROWSE = "Browse...";
    private static final String RESET = "Reset";
    private static final String SERVER_OPTIONS = "Server Options";
    private static final String PAGE_NAME = "TCSetupWizardPage";
    private static final String PAGE_TITLE = "Terracotta Project Setup";
    private static final String PAGE_DESC = "Specify the location of your Terracotta configuration file and\nTerracotta server instance Java runtime options";
    private static final String DEFAULT_CONFIG_FILENAME = "tc-config.xml";
    private static final String DEFAULT_SERVER_OPTIONS = "-Xms256m -Xmx256m";

    public SetupWizardPage(IJavaProject project) {
        super(PAGE_NAME);
        this.m_project = project.getProject();
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
    }

    public void createControl(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        topComp.setLayout((Layout)gridLayout);
        topComp.setLayoutData((Object)new GridData(768));
        Group domainConfig = new Group(topComp, 16);
        domainConfig.setText(TERRACOTTA_CONFIG);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        domainConfig.setLayout((Layout)gridLayout);
        domainConfig.setLayoutData((Object)new GridData(768));
        this.m_configPathField = new Text((Composite)domainConfig, 2052);
        this.m_configPathField.setLayoutData((Object)new GridData(768));
        this.m_configPathField.setText(DEFAULT_CONFIG_FILENAME);
        this.m_configFileButton = new Button((Composite)domainConfig, 8);
        this.m_configFileButton.setText(BROWSE);
        this.m_configFileButton.setLayoutData((Object)new GridData(128));
        SWTUtil.applyDefaultButtonSize(this.m_configFileButton);
        this.m_configFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigFileBehavior behavior = new ConfigFileBehavior();
                PackageNavigator dialog = new PackageNavigator(SetupWizardPage.this.getShell(), behavior.getTitle(), SetupWizardPage.this.m_project, behavior);
                dialog.addValueListener(new UpdateEventListener(){

                    public void handleUpdate(UpdateEvent event) {
                        SetupWizardPage.this.m_configPathField.setText((String)event.data);
                    }
                });
                dialog.open();
            }
        });
        Group serverOptions = new Group(topComp, 16);
        serverOptions.setText(SERVER_OPTIONS);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        serverOptions.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 60;
        serverOptions.setLayoutData((Object)gridData);
        this.m_serverOptionsField = new Text((Composite)serverOptions, 2562);
        GridData gd = new GridData(1808);
        this.m_serverOptionsField.setLayoutData((Object)gd);
        this.m_serverOptionsField.setText(DEFAULT_SERVER_OPTIONS);
        this.m_resetOptionsButton = new Button((Composite)serverOptions, 8);
        this.m_resetOptionsButton.setText(RESET);
        SWTUtil.applyDefaultButtonSize(this.m_resetOptionsButton);
        gridData = (GridData)this.m_resetOptionsButton.getLayoutData();
        gridData.verticalAlignment = 1;
        this.m_resetOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupWizardPage.this.m_serverOptionsField.setText(SetupWizardPage.DEFAULT_SERVER_OPTIONS);
            }
        });
        this.setControl((Control)topComp);
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean canFinish() {
        return this.isPageComplete();
    }

    public String getDomainConfigurationPath() {
        return this.m_configPathField.getText();
    }

    public String getServerOptions() {
        return this.m_serverOptionsField.getText();
    }
}

