/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.wizards;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.BootClassHelper;
import org.terracotta.dso.ProjectNature;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BuildBootJarAction;
import org.terracotta.dso.wizards.SetupWizardPage;
import org.terracotta.ui.util.TcUIStatus;

public class ProjectWizard
extends Wizard {
    private SetupWizardPage m_page;
    private IJavaProject m_javaProject;
    private boolean m_cancelled;

    public ProjectWizard(IJavaProject javaProject) {
        this.m_javaProject = javaProject;
        this.m_cancelled = false;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performCancel() {
        this.m_cancelled = true;
        return super.performCancel();
    }

    public void addPages() {
        this.m_page = new SetupWizardPage(this.m_javaProject);
        this.addPage((IWizardPage)this.m_page);
    }

    public IRunnableWithProgress getWorker() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ProjectWizard.this.doFinish(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        return op;
    }

    public boolean performFinish() {
        if (this.m_cancelled) {
            return true;
        }
        try {
            this.getContainer().run(false, true, this.getWorker());
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            TcPlugin.getDefault().openError("Problem setting up project", cause);
            return false;
        }
        return true;
    }

    private void handleProblem(String msg, Throwable t, IProgressMonitor monitor) throws CoreException {
        t.printStackTrace();
        monitor.setCanceled(true);
        if (!(t instanceof CoreException)) {
            t = new CoreException(TcUIStatus.createError(-1, msg, t));
        }
        throw (CoreException)t;
    }

    public void doFinish(IProgressMonitor monitor) throws CoreException {
        int stepIndex = 1;
        String step = "Adding Terracotta nature";
        monitor.beginTask(step, -1);
        try {
            this.addTerracottaNature(monitor);
        }
        catch (Throwable t) {
            this.handleProblem(step, t, monitor);
        }
        monitor.worked(stepIndex++);
        step = "Creating Terracotta folder";
        monitor.subTask("Creating Terracotta folder");
        try {
            this.ensureConfigExists(monitor);
        }
        catch (Throwable t) {
            this.handleProblem(step, t, monitor);
        }
        monitor.worked(stepIndex++);
        if (!BootClassHelper.canGetBootTypes(this.m_javaProject)) {
            step = "Building BootJar";
            monitor.subTask("Building BootJar");
            try {
                this.buildBootJar(monitor);
            }
            catch (Throwable t) {
                this.handleProblem(step, t, monitor);
            }
            monitor.worked(stepIndex++);
        }
        TcPlugin.getDefault().updateDecorators();
        TcPlugin.getDefault().notifyProjectActions(this.m_javaProject.getProject());
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window instanceof ApplicationWindow) {
            ApplicationWindow appWin = (ApplicationWindow)window;
            String msg = "Finished adding Terracotta Nature.";
            appWin.setStatus(msg);
        }
    }

    private void addTerracottaNature(IProgressMonitor monitor) throws CoreException {
        IProject proj = this.m_javaProject.getProject();
        IProjectDescription description = proj.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = ProjectNature.NATURE_ID;
        description.setNatureIds(newNatures);
        proj.refreshLocal(0, monitor);
        proj.setDescription(description, monitor);
    }

    private String getDomainConfigurationPath() {
        if (this.m_page == null) {
            return "tc-config.xml";
        }
        return this.m_page.getDomainConfigurationPath();
    }

    private String getServerOptions() {
        if (this.m_page == null) {
            return "-Xms256m -Xmx256m";
        }
        return this.m_page.getServerOptions();
    }

    private void ensureConfigExists(IProgressMonitor monitor) throws CoreException {
        IFile configFile;
        TcPlugin plugin = TcPlugin.getDefault();
        IProject project = this.m_javaProject.getProject();
        String configPath = this.getDomainConfigurationPath();
        String serverOpts = this.getServerOptions();
        if (configPath == null || configPath.length() == 0) {
            configPath = "tc-config.xml";
        }
        if (!configPath.endsWith(".xml")) {
            configPath = configPath.concat(".xml");
        }
        if (!(configFile = project.getFile((IPath)new Path(configPath))).exists()) {
            InputStream is = null;
            ProjectWizard.ensureParent(configFile);
            try {
                XmlOptions xmlOpts = plugin.getXmlOptions();
                is = TcPlugin.createTemplateConfigDoc().newInputStream(xmlOpts);
                configFile.create(is, true, monitor);
            }
            catch (CoreException ce) {
                try {
                    String step = "Creating default Terracotta config file";
                    IStatus status = JavaUIStatus.createError((int)-1, (String)step, (Throwable)ce);
                    IOUtils.closeQuietly((InputStream)is);
                    throw new CoreException(status);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        this.m_javaProject.getProject().refreshLocal(2, monitor);
        plugin.setup(project, configPath, serverOpts);
    }

    private static void ensureParent(IFile file) throws CoreException {
        IContainer parent;
        if (!file.exists() && !(parent = file.getParent()).exists()) {
            ProjectWizard.ensureParent(parent);
        }
    }

    private static void ensureParent(IContainer container) throws CoreException {
        if (!container.exists()) {
            IContainer parent = container.getParent();
            if (!parent.exists()) {
                ProjectWizard.ensureParent(parent);
            }
            if (container instanceof IFolder) {
                ((IFolder)container).create(true, true, null);
            }
        }
    }

    private void buildBootJar(IProgressMonitor monitor) {
        BuildBootJarAction bbja = new BuildBootJarAction(this.m_javaProject);
        bbja.run((IAction)null);
    }

    public boolean canFinish() {
        return this.m_page.isPageComplete();
    }
}

