/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.Include;
import com.terracottatech.config.OnLoad;
import org.terracotta.dso.views.InstrumentedClassesWrapper;

public class IncludeWrapper {
    private InstrumentedClassesWrapper m_parent;
    private int m_index;

    IncludeWrapper(InstrumentedClassesWrapper parent, int index) {
        this.m_parent = parent;
        this.m_index = index;
    }

    int getIndex() {
        return this.m_index;
    }

    void remove() {
        this.m_parent.removeInclude(this.m_index);
    }

    InstrumentedClassesWrapper getParent() {
        return this.m_parent;
    }

    Include getInclude() {
        return this.m_parent.getIncludeArray(this.m_index);
    }

    void setClassExpression(String classExpression) {
        this.getInclude().setClassExpression(classExpression);
    }

    String getClassExpression() {
        return this.getInclude().getClassExpression();
    }

    void setHonorTransient(boolean honor) {
        Include include = this.getInclude();
        if (honor) {
            include.setHonorTransient(honor);
        } else if (include.isSetHonorTransient()) {
            include.unsetHonorTransient();
        }
    }

    boolean getHonorTransient() {
        return this.getInclude().getHonorTransient();
    }

    boolean isSetOnLoad() {
        return this.getInclude().isSetOnLoad();
    }

    void unsetOnLoad() {
        Include include = this.getInclude();
        if (include.isSetOnLoad()) {
            include.unsetOnLoad();
        }
    }

    OnLoad ensureOnLoad() {
        Include include = this.getInclude();
        OnLoad onload = include.getOnLoad();
        return onload != null ? onload : include.addNewOnLoad();
    }

    boolean isSetOnLoadExecute() {
        OnLoad onload = this.getInclude().getOnLoad();
        return onload != null && onload.isSetExecute();
    }

    void setOnLoadExecute(String code) {
        OnLoad onload = this.ensureOnLoad();
        onload.setExecute(code);
        if (onload.isSetMethod()) {
            onload.unsetMethod();
        }
    }

    boolean isSetOnLoadMethod() {
        OnLoad onload = this.getInclude().getOnLoad();
        return onload != null && onload.isSetMethod();
    }

    void setOnLoadMethod(String method) {
        OnLoad onload = this.ensureOnLoad();
        onload.setMethod(method);
        if (onload.isSetExecute()) {
            onload.unsetExecute();
        }
    }

    public String toString() {
        return this.getClassExpression();
    }
}

